/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyListData;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.CollectionData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataRefIndexNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.internal.base.CharEscapers;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.shared.internal.NonpluginFunction;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class TranslateToJavaExprVisitor
extends AbstractReturningExprNodeVisitor<JavaExpr> {
    private final Map<String, SoyJavaSrcFunction> soyJavaSrcFunctionsMap;
    private final Deque<Map<String, JavaExpr>> localVarTranslations;

    @AssistedInject
    TranslateToJavaExprVisitor(Map<String, SoyJavaSrcFunction> map, @Assisted Deque<Map<String, JavaExpr>> deque) {
        this.soyJavaSrcFunctionsMap = map;
        this.localVarTranslations = deque;
    }

    @Override
    protected JavaExpr visitExprRootNode(ExprRootNode<?> exprRootNode) {
        return (JavaExpr)this.visit((ExprNode)exprRootNode.getChild(0));
    }

    @Override
    protected JavaExpr visitNullNode(NullNode nullNode) {
        return new JavaExpr("com.google.template.soy.data.restricted.NullData.INSTANCE", NullData.class, Integer.MAX_VALUE);
    }

    @Override
    protected JavaExpr visitBooleanNode(BooleanNode booleanNode) {
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData(booleanNode.toSourceString()));
    }

    @Override
    protected JavaExpr visitIntegerNode(IntegerNode integerNode) {
        return this.convertIntegerResult(JavaCodeUtils.genNewIntegerData(integerNode.toSourceString()));
    }

    @Override
    protected JavaExpr visitFloatNode(FloatNode floatNode) {
        return this.convertFloatResult(JavaCodeUtils.genNewFloatData(floatNode.toSourceString()));
    }

    @Override
    protected JavaExpr visitStringNode(StringNode stringNode) {
        return this.convertStringResult(JavaCodeUtils.genNewStringData('\"' + CharEscapers.javaStringEscaper().escape(stringNode.getValue()) + '\"'));
    }

    @Override
    protected JavaExpr visitListLiteralNode(ListLiteralNode listLiteralNode) {
        return this.convertListResult(JavaCodeUtils.genNewListData(this.buildCommaSepChildrenListHelper(listLiteralNode)));
    }

    @Override
    protected JavaExpr visitMapLiteralNode(MapLiteralNode mapLiteralNode) {
        return this.convertMapResult(JavaCodeUtils.genNewMapData(this.buildCommaSepChildrenListHelper(mapLiteralNode)));
    }

    private String buildCommaSepChildrenListHelper(ExprNode.ParentExprNode parentExprNode) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (ExprNode exprNode : parentExprNode.getChildren()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(((JavaExpr)this.visit(exprNode)).getText());
        }
        return stringBuilder.toString();
    }

    @Override
    protected JavaExpr visitDataRefNode(DataRefNode dataRefNode) {
        if (dataRefNode.isIjDataRef()) {
            return this.convertUnknownResult(JavaCodeUtils.genFunctionCall("this.$$getIjData", this.buildKeyStringExprText(dataRefNode, 0)));
        }
        JavaExpr javaExpr = this.getLocalVarTranslation(dataRefNode.getFirstKey());
        if (javaExpr != null) {
            if (dataRefNode.numChildren() == 1) {
                return javaExpr;
            }
            return this.convertUnknownResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$getData", JavaCodeUtils.genMaybeCast(javaExpr, CollectionData.class), this.buildKeyStringExprText(dataRefNode, 1)));
        }
        return this.convertUnknownResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$getData", "data", this.buildKeyStringExprText(dataRefNode, 0)));
    }

    private String buildKeyStringExprText(DataRefNode dataRefNode, int n) {
        ArrayList arrayList = Lists.newArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < dataRefNode.numChildren(); ++i) {
            ExprNode exprNode = dataRefNode.getChild(i);
            if (i != n) {
                stringBuilder.append(".");
            }
            if (exprNode instanceof DataRefKeyNode) {
                stringBuilder.append(CharEscapers.javaStringEscaper().escape(((DataRefKeyNode)exprNode).getKey()));
                continue;
            }
            if (exprNode instanceof DataRefIndexNode) {
                stringBuilder.append(Integer.toString(((DataRefIndexNode)exprNode).getIndex()));
                continue;
            }
            JavaExpr javaExpr = (JavaExpr)this.visit(exprNode);
            arrayList.add("\"" + stringBuilder.toString() + "\"");
            arrayList.add(JavaCodeUtils.genMaybeProtect(javaExpr, Integer.MAX_VALUE) + ".toString()");
            stringBuilder = new StringBuilder();
        }
        if (stringBuilder.length() > 0) {
            arrayList.add("\"" + stringBuilder.toString() + "\"");
        }
        return Joiner.on((String)" + ").join((Iterable)arrayList);
    }

    @Override
    protected JavaExpr visitGlobalNode(GlobalNode globalNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected JavaExpr visitNegativeOpNode(OperatorNodes.NegativeOpNode negativeOpNode) {
        JavaExpr javaExpr = (JavaExpr)this.visit(negativeOpNode.getChild(0));
        String string = JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genUnaryOp("-", JavaCodeUtils.genIntegerValue(javaExpr)));
        String string2 = JavaCodeUtils.genNewFloatData(JavaCodeUtils.genUnaryOp("-", JavaCodeUtils.genFloatValue(javaExpr)));
        if (JavaCodeUtils.isAlwaysInteger(javaExpr)) {
            return this.convertIntegerResult(string);
        }
        if (JavaCodeUtils.isAlwaysFloat(javaExpr)) {
            return this.convertFloatResult(string2);
        }
        return this.convertNumberResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$negative", JavaCodeUtils.genMaybeCast(javaExpr, NumberData.class)));
    }

    @Override
    protected JavaExpr visitNotOpNode(OperatorNodes.NotOpNode notOpNode) {
        JavaExpr javaExpr = (JavaExpr)this.visit(notOpNode.getChild(0));
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genUnaryOp("!", JavaCodeUtils.genCoerceBoolean(javaExpr))));
    }

    @Override
    protected JavaExpr visitTimesOpNode(OperatorNodes.TimesOpNode timesOpNode) {
        return this.visitNumberToNumberBinaryOpHelper(timesOpNode, "*", "$$times");
    }

    @Override
    protected JavaExpr visitDivideByOpNode(OperatorNodes.DivideByOpNode divideByOpNode) {
        JavaExpr javaExpr = (JavaExpr)this.visit(divideByOpNode.getChild(0));
        JavaExpr javaExpr2 = (JavaExpr)this.visit(divideByOpNode.getChild(1));
        return this.convertFloatResult(JavaCodeUtils.genNewFloatData(JavaCodeUtils.genBinaryOp("/", JavaCodeUtils.genNumberValue(javaExpr), JavaCodeUtils.genNumberValue(javaExpr2))));
    }

    @Override
    protected JavaExpr visitModOpNode(OperatorNodes.ModOpNode modOpNode) {
        JavaExpr javaExpr = (JavaExpr)this.visit(modOpNode.getChild(0));
        JavaExpr javaExpr2 = (JavaExpr)this.visit(modOpNode.getChild(1));
        return this.convertIntegerResult(JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genBinaryOp("%", JavaCodeUtils.genIntegerValue(javaExpr), JavaCodeUtils.genIntegerValue(javaExpr2))));
    }

    @Override
    protected JavaExpr visitPlusOpNode(OperatorNodes.PlusOpNode plusOpNode) {
        JavaExpr javaExpr = (JavaExpr)this.visit(plusOpNode.getChild(0));
        JavaExpr javaExpr2 = (JavaExpr)this.visit(plusOpNode.getChild(1));
        String string = JavaCodeUtils.genNewStringData(JavaCodeUtils.genBinaryOp("+", JavaCodeUtils.genCoerceString(javaExpr), JavaCodeUtils.genCoerceString(javaExpr2)));
        String string2 = JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genBinaryOp("+", JavaCodeUtils.genIntegerValue(javaExpr), JavaCodeUtils.genIntegerValue(javaExpr2)));
        String string3 = JavaCodeUtils.genNewFloatData(JavaCodeUtils.genBinaryOp("+", JavaCodeUtils.genNumberValue(javaExpr), JavaCodeUtils.genNumberValue(javaExpr2)));
        if (JavaCodeUtils.isAlwaysTwoIntegers(javaExpr, javaExpr2)) {
            return this.convertIntegerResult(string2);
        }
        if (JavaCodeUtils.isAlwaysAtLeastOneString(javaExpr, javaExpr2)) {
            return this.convertStringResult(string);
        }
        if (JavaCodeUtils.isAlwaysTwoFloatsOrOneFloatOneInteger(javaExpr, javaExpr2)) {
            return this.convertFloatResult(string3);
        }
        return this.convertUnknownResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$plus", javaExpr.getText(), javaExpr2.getText()));
    }

    @Override
    protected JavaExpr visitMinusOpNode(OperatorNodes.MinusOpNode minusOpNode) {
        return this.visitNumberToNumberBinaryOpHelper(minusOpNode, "-", "$$minus");
    }

    @Override
    protected JavaExpr visitLessThanOpNode(OperatorNodes.LessThanOpNode lessThanOpNode) {
        return this.visitNumberToBooleanBinaryOpHelper(lessThanOpNode, "<", "$$lessThan");
    }

    @Override
    protected JavaExpr visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode greaterThanOpNode) {
        return this.visitNumberToBooleanBinaryOpHelper(greaterThanOpNode, ">", "$$greaterThan");
    }

    @Override
    protected JavaExpr visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode lessThanOrEqualOpNode) {
        return this.visitNumberToBooleanBinaryOpHelper(lessThanOrEqualOpNode, "<=", "$$lessThanOrEqual");
    }

    @Override
    protected JavaExpr visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode greaterThanOrEqualOpNode) {
        return this.visitNumberToBooleanBinaryOpHelper(greaterThanOrEqualOpNode, ">=", "$$greaterThanOrEqual");
    }

    @Override
    protected JavaExpr visitEqualOpNode(OperatorNodes.EqualOpNode equalOpNode) {
        JavaExpr javaExpr = (JavaExpr)this.visit(equalOpNode.getChild(0));
        JavaExpr javaExpr2 = (JavaExpr)this.visit(equalOpNode.getChild(1));
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genMaybeProtect(javaExpr, Integer.MAX_VALUE) + ".equals(" + javaExpr2.getText() + ")"));
    }

    @Override
    protected JavaExpr visitNotEqualOpNode(OperatorNodes.NotEqualOpNode notEqualOpNode) {
        JavaExpr javaExpr = (JavaExpr)this.visit(notEqualOpNode.getChild(0));
        JavaExpr javaExpr2 = (JavaExpr)this.visit(notEqualOpNode.getChild(1));
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData("! " + JavaCodeUtils.genMaybeProtect(javaExpr, Integer.MAX_VALUE) + ".equals(" + javaExpr2.getText() + ")"));
    }

    @Override
    protected JavaExpr visitAndOpNode(OperatorNodes.AndOpNode andOpNode) {
        return this.visitBooleanToBooleanBinaryOpHelper(andOpNode, "&&");
    }

    @Override
    protected JavaExpr visitOrOpNode(OperatorNodes.OrOpNode orOpNode) {
        return this.visitBooleanToBooleanBinaryOpHelper(orOpNode, "||");
    }

    @Override
    protected JavaExpr visitConditionalOpNode(OperatorNodes.ConditionalOpNode conditionalOpNode) {
        JavaExpr javaExpr = (JavaExpr)this.visit(conditionalOpNode.getChild(0));
        JavaExpr javaExpr2 = (JavaExpr)this.visit(conditionalOpNode.getChild(1));
        JavaExpr javaExpr3 = (JavaExpr)this.visit(conditionalOpNode.getChild(2));
        Class<?> clazz = javaExpr2.getType();
        Class<?> clazz2 = javaExpr3.getType();
        Class<?> clazz3 = null;
        for (Class<?> clazz4 = clazz; clazz4 != null; clazz4 = clazz4.getSuperclass()) {
            if (!clazz4.isAssignableFrom(clazz2)) continue;
            clazz3 = clazz4;
            break;
        }
        if (clazz3 == null) {
            throw new AssertionError();
        }
        return new JavaExpr(JavaCodeUtils.genCoerceBoolean(javaExpr) + " ? " + JavaCodeUtils.genMaybeProtect(javaExpr2, Operator.CONDITIONAL.getPrecedence() + 1) + " : " + JavaCodeUtils.genMaybeProtect(javaExpr3, Operator.CONDITIONAL.getPrecedence() + 1), clazz3, Operator.CONDITIONAL.getPrecedence());
    }

    @Override
    protected JavaExpr visitFunctionNode(FunctionNode functionNode) {
        String string = functionNode.getFunctionName();
        int n = functionNode.numChildren();
        NonpluginFunction nonpluginFunction = NonpluginFunction.forFunctionName(string);
        if (nonpluginFunction != null) {
            if (n != nonpluginFunction.getNumArgs()) {
                throw new SoySyntaxException("Function '" + string + "' called with the wrong number of arguments" + " (function call \"" + functionNode.toSourceString() + "\").");
            }
            switch (nonpluginFunction) {
                case IS_FIRST: {
                    return this.visitIsFirstFunction(functionNode);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(functionNode);
                }
                case INDEX: {
                    return this.visitIndexFunction(functionNode);
                }
                case HAS_DATA: {
                    return this.visitHasDataFunction();
                }
            }
            throw new AssertionError();
        }
        SoyJavaSrcFunction soyJavaSrcFunction = this.soyJavaSrcFunctionsMap.get(string);
        if (soyJavaSrcFunction != null) {
            if (!soyJavaSrcFunction.getValidArgsSizes().contains(n)) {
                throw new SoySyntaxException("Function '" + string + "' called with the wrong number of arguments" + " (function call \"" + functionNode.toSourceString() + "\").");
            }
            List<JavaExpr> list = this.visitChildren(functionNode);
            try {
                return soyJavaSrcFunction.computeForJavaSrc(list);
            }
            catch (Exception exception) {
                throw new SoySyntaxException("Error in function call \"" + functionNode.toSourceString() + "\": " + exception.getMessage(), exception);
            }
        }
        throw new SoySyntaxException("Failed to find SoyJavaSrcFunction with name '" + string + "'" + " (function call \"" + functionNode.toSourceString() + "\").");
    }

    private JavaExpr visitIsFirstFunction(FunctionNode functionNode) {
        String string = ((DataRefNode)functionNode.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(string + "__isFirst");
    }

    private JavaExpr visitIsLastFunction(FunctionNode functionNode) {
        String string = ((DataRefNode)functionNode.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(string + "__isLast");
    }

    private JavaExpr visitIndexFunction(FunctionNode functionNode) {
        String string = ((DataRefNode)functionNode.getChild(0)).getFirstKey();
        return this.getLocalVarTranslation(string + "__index");
    }

    private JavaExpr visitHasDataFunction() {
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData("data != null"));
    }

    private JavaExpr convertBooleanResult(String string) {
        return new JavaExpr(string, BooleanData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertIntegerResult(String string) {
        return new JavaExpr(string, IntegerData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertFloatResult(String string) {
        return new JavaExpr(string, FloatData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertNumberResult(String string) {
        return new JavaExpr(string, NumberData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertStringResult(String string) {
        return new JavaExpr(string, StringData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertListResult(String string) {
        return new JavaExpr(string, SoyListData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertMapResult(String string) {
        return new JavaExpr(string, SoyMapData.class, Integer.MAX_VALUE);
    }

    private JavaExpr convertUnknownResult(String string) {
        return new JavaExpr(string, SoyData.class, Integer.MAX_VALUE);
    }

    private JavaExpr visitBooleanToBooleanBinaryOpHelper(ExprNode.OperatorNode operatorNode, String string) {
        JavaExpr javaExpr = (JavaExpr)this.visit((ExprNode)operatorNode.getChild(0));
        JavaExpr javaExpr2 = (JavaExpr)this.visit((ExprNode)operatorNode.getChild(1));
        return this.convertBooleanResult(JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genBinaryOp(string, JavaCodeUtils.genCoerceBoolean(javaExpr), JavaCodeUtils.genCoerceBoolean(javaExpr2))));
    }

    private JavaExpr visitNumberToNumberBinaryOpHelper(ExprNode.OperatorNode operatorNode, String string, String string2) {
        JavaExpr javaExpr = (JavaExpr)this.visit((ExprNode)operatorNode.getChild(0));
        JavaExpr javaExpr2 = (JavaExpr)this.visit((ExprNode)operatorNode.getChild(1));
        String string3 = JavaCodeUtils.genNewIntegerData(JavaCodeUtils.genBinaryOp(string, JavaCodeUtils.genIntegerValue(javaExpr), JavaCodeUtils.genIntegerValue(javaExpr2)));
        String string4 = JavaCodeUtils.genNewFloatData(JavaCodeUtils.genBinaryOp(string, JavaCodeUtils.genNumberValue(javaExpr), JavaCodeUtils.genNumberValue(javaExpr2)));
        if (JavaCodeUtils.isAlwaysTwoIntegers(javaExpr, javaExpr2)) {
            return this.convertIntegerResult(string3);
        }
        if (JavaCodeUtils.isAlwaysAtLeastOneFloat(javaExpr, javaExpr2)) {
            return this.convertFloatResult(string4);
        }
        return this.convertNumberResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils." + string2, JavaCodeUtils.genMaybeCast(javaExpr, NumberData.class), JavaCodeUtils.genMaybeCast(javaExpr2, NumberData.class)));
    }

    private JavaExpr visitNumberToBooleanBinaryOpHelper(ExprNode.OperatorNode operatorNode, String string, String string2) {
        JavaExpr javaExpr = (JavaExpr)this.visit((ExprNode)operatorNode.getChild(0));
        JavaExpr javaExpr2 = (JavaExpr)this.visit((ExprNode)operatorNode.getChild(1));
        String string3 = JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genBinaryOp(string, JavaCodeUtils.genIntegerValue(javaExpr), JavaCodeUtils.genIntegerValue(javaExpr2)));
        String string4 = JavaCodeUtils.genNewBooleanData(JavaCodeUtils.genBinaryOp(string, JavaCodeUtils.genNumberValue(javaExpr), JavaCodeUtils.genNumberValue(javaExpr2)));
        if (JavaCodeUtils.isAlwaysTwoIntegers(javaExpr, javaExpr2)) {
            return this.convertBooleanResult(string3);
        }
        if (JavaCodeUtils.isAlwaysAtLeastOneFloat(javaExpr, javaExpr2)) {
            return this.convertBooleanResult(string4);
        }
        return this.convertBooleanResult(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils." + string2, JavaCodeUtils.genMaybeCast(javaExpr, NumberData.class), JavaCodeUtils.genMaybeCast(javaExpr2, NumberData.class)));
    }

    private JavaExpr getLocalVarTranslation(String string) {
        for (Map<String, JavaExpr> map : this.localVarTranslations) {
            JavaExpr javaExpr = map.get(string);
            if (javaExpr == null) continue;
            return javaExpr;
        }
        return null;
    }

    public static interface TranslateToJavaExprVisitorFactory {
        public TranslateToJavaExprVisitor create(Deque<Map<String, JavaExpr>> var1);
    }
}

