/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.internal;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.shared.internal.ApiCallScope;
import com.google.template.soy.soytree.AbstractReturningSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CssNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForeachNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Map;

@ApiCallScope
class IsComputableAsJavaExprsVisitor
extends AbstractReturningSoyNodeVisitor<Boolean> {
    private final SoyJavaSrcOptions javaSrcOptions;
    private final Map<SoyNode, Boolean> memoizedResults;

    @Inject
    public IsComputableAsJavaExprsVisitor(SoyJavaSrcOptions soyJavaSrcOptions) {
        this.javaSrcOptions = soyJavaSrcOptions;
        this.memoizedResults = Maps.newHashMap();
    }

    @Override
    protected Boolean visit(SoyNode soyNode) {
        if (this.memoizedResults.containsKey(soyNode)) {
            return this.memoizedResults.get(soyNode);
        }
        Boolean bl = (Boolean)super.visit(soyNode);
        this.memoizedResults.put(soyNode, bl);
        return bl;
    }

    @Override
    protected Boolean visitTemplateNode(TemplateNode templateNode) {
        return this.areChildrenComputableAsJavaExprs(templateNode);
    }

    @Override
    protected Boolean visitRawTextNode(RawTextNode rawTextNode) {
        return true;
    }

    @Override
    protected Boolean visitMsgPlaceholderNode(MsgPlaceholderNode msgPlaceholderNode) {
        return this.areChildrenComputableAsJavaExprs(msgPlaceholderNode);
    }

    @Override
    protected Boolean visitMsgHtmlTagNode(MsgHtmlTagNode msgHtmlTagNode) {
        return this.areChildrenComputableAsJavaExprs(msgHtmlTagNode);
    }

    @Override
    protected Boolean visitPrintNode(PrintNode printNode) {
        return true;
    }

    @Override
    protected Boolean visitCssNode(CssNode cssNode) {
        return true;
    }

    @Override
    protected Boolean visitLetNode(LetNode letNode) {
        return false;
    }

    @Override
    protected Boolean visitIfNode(IfNode ifNode) {
        return this.areChildrenComputableAsJavaExprs(ifNode);
    }

    @Override
    protected Boolean visitIfCondNode(IfCondNode ifCondNode) {
        return this.areChildrenComputableAsJavaExprs(ifCondNode);
    }

    @Override
    protected Boolean visitIfElseNode(IfElseNode ifElseNode) {
        return this.areChildrenComputableAsJavaExprs(ifElseNode);
    }

    @Override
    protected Boolean visitSwitchNode(SwitchNode switchNode) {
        return false;
    }

    @Override
    protected Boolean visitForeachNode(ForeachNode foreachNode) {
        return false;
    }

    @Override
    protected Boolean visitForNode(ForNode forNode) {
        return false;
    }

    @Override
    protected Boolean visitCallNode(CallNode callNode) {
        return this.javaSrcOptions.getCodeStyle() == SoyJavaSrcOptions.CodeStyle.CONCAT && this.areChildrenComputableAsJavaExprs(callNode);
    }

    @Override
    protected Boolean visitCallParamValueNode(CallParamValueNode callParamValueNode) {
        return true;
    }

    @Override
    protected Boolean visitCallParamContentNode(CallParamContentNode callParamContentNode) {
        return this.areChildrenComputableAsJavaExprs(callParamContentNode);
    }

    private boolean areChildrenComputableAsJavaExprs(SoyNode.ParentSoyNode<?> parentSoyNode) {
        for (SoyNode soyNode : parentSoyNode.getChildren()) {
            if (soyNode instanceof RawTextNode || soyNode instanceof PrintNode || this.visit(soyNode).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

