/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javasrc.dyncompile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.javasrc.dyncompile.ClasspathJavaFileObject;
import com.google.template.soy.javasrc.dyncompile.ClasspathUtils;
import com.google.template.soy.javasrc.dyncompile.InMemoryJavaFileObject;
import com.google.template.soy.javasrc.dyncompile.ReadableInMemoryJavaFileObject;
import com.google.template.soy.javasrc.dyncompile.WritableInMemoryJavaFileObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

final class DynamicCompilerJavaFileManager
implements JavaFileManager {
    private final List<ReadableInMemoryJavaFileObject> inputFiles = Lists.newArrayList();
    private final List<WritableInMemoryJavaFileObject> outputFiles = Lists.newArrayList();
    private final StandardJavaFileManager standardFileManager;

    DynamicCompilerJavaFileManager(StandardJavaFileManager standardJavaFileManager) {
        this.standardFileManager = standardJavaFileManager;
    }

    List<ReadableInMemoryJavaFileObject> getInputFiles() {
        return ImmutableList.copyOf(this.inputFiles);
    }

    List<WritableInMemoryJavaFileObject> getOutputFiles() {
        return ImmutableList.copyOf(this.outputFiles);
    }

    void addInput(ReadableInMemoryJavaFileObject readableInMemoryJavaFileObject) {
        this.inputFiles.add(readableInMemoryJavaFileObject);
    }

    @Override
    public int isSupportedOption(String string) {
        return -1;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return null;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (StandardLocation.SOURCE_PATH.equals(location) && set.contains((Object)JavaFileObject.Kind.SOURCE) && ("com.google.template.soy.javasrc.dyncompiled".equals(string) || bl && "com.google.template.soy.javasrc.dyncompiled".startsWith(string + "."))) {
            builder.addAll(this.inputFiles);
        }
        if (StandardLocation.CLASS_PATH.equals(location) && set.contains((Object)JavaFileObject.Kind.CLASS)) {
            for (String string2 : ClasspathUtils.getClassResourcePaths(string, bl)) {
                builder.add((Object)new ClasspathJavaFileObject("/" + string2));
            }
        }
        if (StandardLocation.PLATFORM_CLASS_PATH.equals(location)) {
            builder.addAll(this.standardFileManager.list(location, string, set, bl));
        }
        return builder.build();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        int n;
        String string;
        if (javaFileObject instanceof InMemoryJavaFileObject) {
            string = ((InMemoryJavaFileObject)javaFileObject).getPath();
            if (string.startsWith("/src/") || string.startsWith("/out/")) {
                string = string.substring(5);
            }
        } else if (javaFileObject instanceof ClasspathJavaFileObject) {
            string = ((ClasspathJavaFileObject)javaFileObject).getResourcePath();
        } else {
            return this.standardFileManager.inferBinaryName(location, javaFileObject);
        }
        if ((n = string.lastIndexOf(46)) >= 0) {
            string = string.substring(0, n);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return string.replace('/', '.');
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        return fileObject == fileObject2 || fileObject.toUri().equals(fileObject2.toUri());
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return StandardLocation.CLASS_OUTPUT.equals(location) || StandardLocation.SOURCE_PATH.equals(location) || StandardLocation.CLASS_PATH.equals(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        throw new IOException();
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        if (!StandardLocation.CLASS_OUTPUT.equals(location)) {
            throw new FileNotFoundException();
        }
        String string2 = "/out/" + string.replace('.', '/') + ".class";
        for (WritableInMemoryJavaFileObject writableInMemoryJavaFileObject : this.outputFiles) {
            if (!writableInMemoryJavaFileObject.getPath().equals(string2)) continue;
            throw new IOException("Overwriting output file " + string2);
        }
        WritableInMemoryJavaFileObject writableInMemoryJavaFileObject = new WritableInMemoryJavaFileObject(string2);
        this.outputFiles.add(writableInMemoryJavaFileObject);
        return writableInMemoryJavaFileObject;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        throw new IOException();
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        throw new IOException();
    }

    @Override
    public void flush() throws IOException {
        this.standardFileManager.flush();
    }

    @Override
    public void close() throws IOException {
        this.standardFileManager.close();
    }
}

