/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.i18n;

import com.google.common.base.Preconditions;
import com.google.template.soy.internal.i18n.BidiFormatter;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.BidiUtils;
import java.util.EnumMap;
import java.util.regex.Pattern;

public class SoyBidiUtils {
    private static final String GOOG_IS_RTL_CODE_SNIPPET = "goog.i18n.bidi.IS_RTL";
    private static EnumMap<BidiUtils.Dir, BidiFormatter> bidiFormatterCache = new EnumMap(BidiUtils.Dir.class);
    private static final Pattern FAKE_RTL_LOCALES_PATTERN = Pattern.compile("qbi|.*[-_]psrtl", 2);

    private SoyBidiUtils() {
    }

    public static int getBidiGlobalDir(String string) {
        boolean bl;
        try {
            bl = string != null && (BidiUtils.isRtlLanguage(string) || FAKE_RTL_LOCALES_PATTERN.matcher(string).matches());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        return bl ? -1 : 1;
    }

    public static BidiGlobalDir decodeBidiGlobalDir(int n) {
        return SoyBidiUtils.decodeBidiGlobalDirFromOptions(n, false);
    }

    public static BidiGlobalDir decodeBidiGlobalDirFromOptions(int n, boolean bl) {
        if (n == 0) {
            if (!bl) {
                return null;
            }
            return BidiGlobalDir.forIsRtlCodeSnippet(GOOG_IS_RTL_CODE_SNIPPET);
        }
        Preconditions.checkState((!bl ? 1 : 0) != 0, (Object)"Must not specify both bidiGlobalDir and bidiGlobalDirIsRtlCodeSnippet.");
        Preconditions.checkArgument((n == 1 || n == -1 ? 1 : 0) != 0, (Object)"If specified, bidiGlobalDir must be 1 for LTR or -1 for RTL.");
        return BidiGlobalDir.forStaticIsRtl(n < 0);
    }

    public static BidiFormatter getBidiFormatter(int n) {
        BidiUtils.Dir dir = BidiUtils.Dir.valueOf(n);
        BidiFormatter bidiFormatter = bidiFormatterCache.get((Object)dir);
        if (bidiFormatter == null) {
            bidiFormatter = BidiFormatter.getInstance(dir);
            bidiFormatterCache.put(dir, bidiFormatter);
        }
        return bidiFormatter;
    }
}

