/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.i18n;

import java.util.regex.Pattern;

public class BidiUtils {
    private static final Pattern RtlLocalesRe = Pattern.compile("^(ar|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|.*[-_](Arab|Hebr|Thaa|Nkoo|Tfng))(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)");
    public static final String RIGHT = "right";
    public static final String LEFT = "left";

    private BidiUtils() {
    }

    public static Dir languageDir(String string) {
        return BidiUtils.isRtlLanguage(string) ? Dir.RTL : Dir.LTR;
    }

    public static boolean isRtlLanguage(String string) {
        return string != null && RtlLocalesRe.matcher(string).find();
    }

    public static boolean hasAnyLtr(String string, boolean bl) {
        return new DirectionalityEstimator(string, bl).hasAnyLtr(false);
    }

    public static boolean hasAnyLtr(String string) {
        return BidiUtils.hasAnyLtr(string, false);
    }

    public static boolean hasAnyRtl(String string, boolean bl) {
        return new DirectionalityEstimator(string, bl).hasAnyRtl(false);
    }

    public static boolean hasAnyRtl(String string) {
        return BidiUtils.hasAnyRtl(string, false);
    }

    public static boolean startsWithLtr(String string, boolean bl) {
        return new DirectionalityEstimator(string, bl).firstStrong(true) == Dir.LTR;
    }

    public static boolean startsWithLtr(String string) {
        return BidiUtils.startsWithLtr(string, false);
    }

    public static boolean startsWithRtl(String string, boolean bl) {
        return new DirectionalityEstimator(string, bl).firstStrong(true) == Dir.RTL;
    }

    public static boolean startsWithRtl(String string) {
        return BidiUtils.startsWithRtl(string, false);
    }

    public static boolean endsWithLtr(String string, boolean bl) {
        return new DirectionalityEstimator(string, bl).lastStrong(true) == Dir.LTR;
    }

    public static boolean endsWithLtr(String string) {
        return BidiUtils.endsWithLtr(string, false);
    }

    public static boolean endsWithRtl(String string, boolean bl) {
        return new DirectionalityEstimator(string, bl).lastStrong(true) == Dir.RTL;
    }

    public static boolean endsWithRtl(String string) {
        return BidiUtils.endsWithRtl(string, false);
    }

    public static Dir estimateDirection(String string) {
        return BidiUtils.estimateDirection(string, false);
    }

    public static Dir estimateDirection(String string, boolean bl) {
        return new DirectionalityEstimator(string, bl).estimateDirectionByWordCount();
    }

    static class DirectionalityEstimator
    extends DirTypeIterator {
        private static final double RTL_THRESHOLD = 0.4;
        private int ltrWordCount;
        private int rtlWordCount;
        private int weakLtrWordCount;
        private int embedLevel;
        private int wordType;

        public DirectionalityEstimator(String string, boolean bl) {
            super(string, bl);
        }

        public Dir estimateDirectionByWordCount() {
            this.rewind(false);
            this.ltrWordCount = 0;
            this.rtlWordCount = 0;
            this.weakLtrWordCount = 0;
            this.embedLevel = 0;
            this.wordType = 0;
            block12: while (!this.atEnd()) {
                switch (this.dirTypeForward()) {
                    case 1: 
                    case 2: {
                        this.strongWord(true);
                        continue block12;
                    }
                    case 0: {
                        if (this.wordType == 0 && this.getLastChar() == 'h' && (this.matchForward("ttp://", true) || this.matchForward("ttps://", true))) {
                            this.wordType = 3;
                            ++this.weakLtrWordCount;
                            continue block12;
                        }
                        this.strongWord(false);
                        continue block12;
                    }
                    case 3: 
                    case 6: {
                        if (this.wordType >= 1) continue block12;
                        ++this.weakLtrWordCount;
                        this.wordType = 1;
                        continue block12;
                    }
                    case 11: 
                    case 12: {
                        if (this.wordType >= 4) continue block12;
                        this.wordType = 0;
                        continue block12;
                    }
                    case 10: {
                        this.embedLevel = 0;
                        this.wordType = 0;
                        continue block12;
                    }
                    case 15: {
                        this.strongWord(false);
                    }
                    case 14: {
                        if (this.embedLevel++ != 0) continue block12;
                        this.wordType = 4;
                        continue block12;
                    }
                    case 17: {
                        this.strongWord(true);
                    }
                    case 16: {
                        if (this.embedLevel++ != 0) continue block12;
                        this.wordType = 4;
                        continue block12;
                    }
                    case 18: {
                        if (--this.embedLevel != 0) continue block12;
                        this.wordType = 0;
                        continue block12;
                    }
                }
            }
            if ((double)this.rtlWordCount > (double)(this.ltrWordCount + this.rtlWordCount) * 0.4) {
                return Dir.RTL;
            }
            if (this.ltrWordCount + this.weakLtrWordCount > 0) {
                return Dir.LTR;
            }
            return Dir.UNKNOWN;
        }

        private void strongWord(boolean bl) {
            if (this.wordType < 2) {
                if (bl) {
                    ++this.rtlWordCount;
                } else {
                    ++this.ltrWordCount;
                }
                if (this.wordType == 1) {
                    --this.weakLtrWordCount;
                }
                this.wordType = 2;
            }
        }

        public boolean hasAnyLtr(boolean bl) {
            this.rewind(false);
            int n = 0;
            while (!this.atEnd()) {
                switch (this.dirTypeForward()) {
                    case 0: {
                        if (n != 0) break;
                        return true;
                    }
                    case 14: 
                    case 15: {
                        if (!bl || n++ != 0) break;
                        return true;
                    }
                    case 16: 
                    case 17: {
                        if (!bl) break;
                        ++n;
                        break;
                    }
                    case 18: {
                        if (!bl) break;
                        --n;
                    }
                }
            }
            return false;
        }

        public boolean hasAnyRtl(boolean bl) {
            this.rewind(false);
            int n = 0;
            while (!this.atEnd()) {
                switch (this.dirTypeForward()) {
                    case 1: 
                    case 2: {
                        if (n != 0) break;
                        return true;
                    }
                    case 16: 
                    case 17: {
                        if (!bl || n++ != 0) break;
                        return true;
                    }
                    case 14: 
                    case 15: {
                        if (!bl) break;
                        ++n;
                        break;
                    }
                    case 18: {
                        if (!bl) break;
                        --n;
                    }
                }
            }
            return false;
        }

        public Dir firstStrong(boolean bl) {
            this.rewind(false);
            while (!this.atEnd()) {
                switch (this.dirTypeForward()) {
                    case 0: {
                        return Dir.LTR;
                    }
                    case 14: 
                    case 15: {
                        if (!bl) break;
                        return Dir.LTR;
                    }
                    case 1: 
                    case 2: {
                        return Dir.RTL;
                    }
                    case 16: 
                    case 17: {
                        if (!bl) break;
                        return Dir.RTL;
                    }
                }
            }
            return Dir.UNKNOWN;
        }

        public Dir lastStrong(boolean bl) {
            this.rewind(true);
            int n = 0;
            while (!this.atStart()) {
                switch (this.dirTypeBackward()) {
                    case 0: {
                        if (n != 0) break;
                        return Dir.LTR;
                    }
                    case 14: 
                    case 15: {
                        if (!bl || --n != 0) break;
                        return Dir.LTR;
                    }
                    case 1: 
                    case 2: {
                        if (n != 0) break;
                        return Dir.RTL;
                    }
                    case 16: 
                    case 17: {
                        if (!bl || --n != 0) break;
                        return Dir.RTL;
                    }
                    case 18: {
                        if (!bl) break;
                        ++n;
                    }
                }
            }
            return Dir.UNKNOWN;
        }

        private static class WordType {
            public static final int NEUTRAL = 0;
            public static final int NUMERIC = 1;
            public static final int STRONG = 2;
            public static final int URL = 3;
            public static final int EMBEDDED = 4;

            private WordType() {
            }
        }
    }

    static class DirTypeIterator {
        private static final int DIR_TYPE_CACHE_SIZE = 1792;
        private static final byte UNKNOWN_DIR_TYPE = 127;
        private static byte[] dirTypeCache = new byte[1792];
        private CharSequence text;
        private int length;
        private boolean isHtml;
        private int charIndex;
        private char lastChar;

        private static byte getCachedDirectionality(char c) {
            if (c >= '\u0700') {
                return Character.getDirectionality(c);
            }
            byte by = dirTypeCache[c];
            if (by == 127) {
                DirTypeIterator.dirTypeCache[c] = by = Character.getDirectionality(c);
            }
            return by;
        }

        public DirTypeIterator(CharSequence charSequence, boolean bl) {
            this.text = charSequence;
            this.isHtml = bl;
            this.length = charSequence.length();
            this.rewind(false);
        }

        public boolean atEnd() {
            return this.charIndex == this.length;
        }

        public boolean atStart() {
            return this.charIndex == 0;
        }

        public char getLastChar() {
            return this.lastChar;
        }

        public void rewind(boolean bl) {
            this.charIndex = bl ? this.length : 0;
            this.lastChar = (char)55296;
        }

        public char charForward() {
            this.lastChar = this.text.charAt(this.charIndex);
            this.charIndex = Character.isHighSurrogate(this.lastChar) ? (this.charIndex += Character.charCount(Character.codePointAt(this.text, this.charIndex))) : ++this.charIndex;
            return this.lastChar;
        }

        public char charBackward() {
            this.lastChar = this.text.charAt(this.charIndex - 1);
            this.charIndex = Character.isLowSurrogate(this.lastChar) ? (this.charIndex -= Character.charCount(Character.codePointBefore(this.text, this.charIndex))) : --this.charIndex;
            return this.lastChar;
        }

        public boolean matchForward(CharSequence charSequence, boolean bl) {
            int n = charSequence.length();
            if (n > this.length - this.charIndex) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.text.charAt(this.charIndex + i) == charSequence.charAt(i)) continue;
                return false;
            }
            if (bl) {
                this.charIndex += n;
            }
            return true;
        }

        public byte dirTypeForward() {
            this.lastChar = this.text.charAt(this.charIndex);
            if (Character.isHighSurrogate(this.lastChar)) {
                int n = Character.codePointAt(this.text, this.charIndex);
                this.charIndex += Character.charCount(n);
                return Character.getDirectionality(n);
            }
            ++this.charIndex;
            byte by = DirTypeIterator.getCachedDirectionality(this.lastChar);
            if (this.isHtml) {
                if (this.lastChar == '<') {
                    by = this.skipTagForward();
                } else if (this.lastChar == '&') {
                    by = this.skipEntityForward();
                }
            }
            return by;
        }

        public byte dirTypeBackward() {
            this.lastChar = this.text.charAt(this.charIndex - 1);
            if (Character.isLowSurrogate(this.lastChar)) {
                int n = Character.codePointBefore(this.text, this.charIndex);
                this.charIndex -= Character.charCount(n);
                return Character.getDirectionality(n);
            }
            --this.charIndex;
            byte by = DirTypeIterator.getCachedDirectionality(this.lastChar);
            if (this.isHtml) {
                if (this.lastChar == '>') {
                    by = this.skipTagBackward();
                } else if (this.lastChar == ';') {
                    by = this.skipEntityBackward();
                }
            }
            return by;
        }

        private byte skipTagForward() {
            char c;
            while (!this.atEnd() && (c = this.charForward()) != '>') {
                if (c != '\"' && c != '\'') continue;
                while (!this.atEnd() && this.charForward() != c) {
                }
            }
            return 12;
        }

        private byte skipTagBackward() {
            int n = this.charIndex;
            while (!this.atStart()) {
                char c = this.charBackward();
                if (c == '<') {
                    return 12;
                }
                if (c == '>') break;
                if (c != '\"' && c != '\'') continue;
                while (!this.atStart() && this.charBackward() != c) {
                }
            }
            this.charIndex = n;
            this.lastChar = (char)62;
            return 13;
        }

        private byte skipEntityForward() {
            while (!this.atEnd() && this.charForward() != ';') {
            }
            return 12;
        }

        private byte skipEntityBackward() {
            int n = this.charIndex;
            while (!this.atStart()) {
                char c = this.charBackward();
                if (c == '&') {
                    return 12;
                }
                if (c != ';') continue;
                break;
            }
            this.charIndex = n;
            this.lastChar = (char)59;
            return 13;
        }

        static {
            for (int i = 0; i < 1792; ++i) {
                DirTypeIterator.dirTypeCache[i] = 127;
            }
        }
    }

    public static final class Format {
        public static final char LRE = '\u202a';
        public static final char RLE = '\u202b';
        public static final char PDF = '\u202c';
        public static final char LRM = '\u200e';
        public static final char RLM = '\u200f';
        public static final String LRM_STRING = Character.toString('\u200e');
        public static final String RLM_STRING = Character.toString('\u200f');

        private Format() {
        }
    }

    public static enum Dir {
        LTR(1),
        UNKNOWN(0),
        RTL(-1);

        public final int ord;

        private Dir(int n2) {
            this.ord = n2;
        }

        public static Dir valueOf(int n) {
            return n > 0 ? LTR : (n < 0 ? RTL : UNKNOWN);
        }

        public static Dir valueOf(boolean bl) {
            return bl ? RTL : LTR;
        }

        public boolean isOppositeTo(Dir dir) {
            return this.ord * dir.ord < 0;
        }
    }
}

