/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.i18n;

import com.google.common.base.Preconditions;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import javax.annotation.Nullable;

public class BidiGlobalDir {
    private String codeSnippet;
    private int staticValue;

    private BidiGlobalDir(int n) {
        this.staticValue = n;
        this.codeSnippet = Integer.toString(n);
    }

    private BidiGlobalDir(String string) {
        this.codeSnippet = string;
    }

    public static BidiGlobalDir forStaticIsRtl(boolean bl) {
        return new BidiGlobalDir(bl ? -1 : 1);
    }

    public static BidiGlobalDir forStaticLocale(@Nullable String string) {
        return new BidiGlobalDir(SoyBidiUtils.getBidiGlobalDir(string));
    }

    public static BidiGlobalDir forIsRtlCodeSnippet(String string) {
        Preconditions.checkArgument((string != null && string.length() > 0 ? 1 : 0) != 0, (Object)"Bidi global direction source code snippet must be non-empty.");
        return new BidiGlobalDir(string + "?-1:1");
    }

    public boolean isStaticValue() {
        return this.staticValue != 0;
    }

    public int getStaticValue() {
        if (this.staticValue == 0) {
            throw new RuntimeException("Cannot get static value for nonstatic BidiGlobalDir object.");
        }
        return this.staticValue;
    }

    public String getCodeSnippet() {
        return this.codeSnippet;
    }
}

