/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.Operator;
import java.util.List;

public abstract class AbstractOperatorNode
extends AbstractParentExprNode
implements ExprNode.OperatorNode {
    private final Operator operator;

    public AbstractOperatorNode(Operator operator) {
        this.operator = operator;
    }

    protected AbstractOperatorNode(AbstractOperatorNode abstractOperatorNode) {
        super(abstractOperatorNode);
        this.operator = abstractOperatorNode.operator;
    }

    @Override
    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public String toSourceString() {
        boolean bl = this.operator.getAssociativity() == Operator.Associativity.LEFT;
        StringBuilder stringBuilder = new StringBuilder();
        List<Operator.SyntaxElement> list = this.operator.getSyntax();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Operator.SyntaxElement syntaxElement = list.get(i);
            if (syntaxElement instanceof Operator.Operand) {
                Operator.Operand operand = (Operator.Operand)syntaxElement;
                if (i == (bl ? 0 : n - 1)) {
                    stringBuilder.append(this.getOperandProtectedForLowerPrec(operand.getIndex()));
                    continue;
                }
                stringBuilder.append(this.getOperandProtectedForLowerOrEqualPrec(operand.getIndex()));
                continue;
            }
            if (syntaxElement instanceof Operator.Token) {
                stringBuilder.append(((Operator.Token)syntaxElement).getValue());
                continue;
            }
            if (syntaxElement instanceof Operator.Spacer) {
                stringBuilder.append(' ');
                continue;
            }
            throw new AssertionError();
        }
        return stringBuilder.toString();
    }

    private String getOperandProtectedForLowerPrec(int n) {
        return this.getOperandProtectedForPrecHelper(n, false);
    }

    private String getOperandProtectedForLowerOrEqualPrec(int n) {
        return this.getOperandProtectedForPrecHelper(n, true);
    }

    private String getOperandProtectedForPrecHelper(int n, boolean bl) {
        boolean bl2;
        int n2 = this.operator.getPrecedence();
        ExprNode exprNode = this.getChild(n);
        if (exprNode instanceof ExprNode.OperatorNode) {
            int n3 = ((ExprNode.OperatorNode)exprNode).getOperator().getPrecedence();
            bl2 = bl ? n3 <= n2 : n3 < n2;
        } else {
            bl2 = false;
        }
        if (bl2) {
            return "(" + exprNode.toSourceString() + ")";
        }
        return exprNode.toSourceString();
    }
}

