/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.template.soy.basetree.AbstractNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataRefIndexNode;
import com.google.template.soy.exprtree.DataRefKeyNode;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarNode;

public abstract class AbstractExprNodeVisitor<R>
extends AbstractNodeVisitor<ExprNode, R> {
    @Override
    protected void visit(ExprNode exprNode) {
        switch (exprNode.getKind()) {
            case EXPR_ROOT_NODE: {
                this.visitExprRootNode((ExprRootNode)exprNode);
                break;
            }
            case NULL_NODE: {
                this.visitNullNode((NullNode)exprNode);
                break;
            }
            case BOOLEAN_NODE: {
                this.visitBooleanNode((BooleanNode)exprNode);
                break;
            }
            case INTEGER_NODE: {
                this.visitIntegerNode((IntegerNode)exprNode);
                break;
            }
            case FLOAT_NODE: {
                this.visitFloatNode((FloatNode)exprNode);
                break;
            }
            case STRING_NODE: {
                this.visitStringNode((StringNode)exprNode);
                break;
            }
            case LIST_LITERAL_NODE: {
                this.visitListLiteralNode((ListLiteralNode)exprNode);
                break;
            }
            case MAP_LITERAL_NODE: {
                this.visitMapLiteralNode((MapLiteralNode)exprNode);
                break;
            }
            case VAR_NODE: {
                this.visitVarNode((VarNode)exprNode);
                break;
            }
            case DATA_REF_NODE: {
                this.visitDataRefNode((DataRefNode)exprNode);
                break;
            }
            case DATA_REF_KEY_NODE: {
                this.visitDataRefKeyNode((DataRefKeyNode)exprNode);
                break;
            }
            case DATA_REF_INDEX_NODE: {
                this.visitDataRefIndexNode((DataRefIndexNode)exprNode);
                break;
            }
            case GLOBAL_NODE: {
                this.visitGlobalNode((GlobalNode)exprNode);
                break;
            }
            case NEGATIVE_OP_NODE: {
                this.visitNegativeOpNode((OperatorNodes.NegativeOpNode)exprNode);
                break;
            }
            case NOT_OP_NODE: {
                this.visitNotOpNode((OperatorNodes.NotOpNode)exprNode);
                break;
            }
            case TIMES_OP_NODE: {
                this.visitTimesOpNode((OperatorNodes.TimesOpNode)exprNode);
                break;
            }
            case DIVIDE_BY_OP_NODE: {
                this.visitDivideByOpNode((OperatorNodes.DivideByOpNode)exprNode);
                break;
            }
            case MOD_OP_NODE: {
                this.visitModOpNode((OperatorNodes.ModOpNode)exprNode);
                break;
            }
            case PLUS_OP_NODE: {
                this.visitPlusOpNode((OperatorNodes.PlusOpNode)exprNode);
                break;
            }
            case MINUS_OP_NODE: {
                this.visitMinusOpNode((OperatorNodes.MinusOpNode)exprNode);
                break;
            }
            case LESS_THAN_OP_NODE: {
                this.visitLessThanOpNode((OperatorNodes.LessThanOpNode)exprNode);
                break;
            }
            case GREATER_THAN_OP_NODE: {
                this.visitGreaterThanOpNode((OperatorNodes.GreaterThanOpNode)exprNode);
                break;
            }
            case LESS_THAN_OR_EQUAL_OP_NODE: {
                this.visitLessThanOrEqualOpNode((OperatorNodes.LessThanOrEqualOpNode)exprNode);
                break;
            }
            case GREATER_THAN_OR_EQUAL_OP_NODE: {
                this.visitGreaterThanOrEqualOpNode((OperatorNodes.GreaterThanOrEqualOpNode)exprNode);
                break;
            }
            case EQUAL_OP_NODE: {
                this.visitEqualOpNode((OperatorNodes.EqualOpNode)exprNode);
                break;
            }
            case NOT_EQUAL_OP_NODE: {
                this.visitNotEqualOpNode((OperatorNodes.NotEqualOpNode)exprNode);
                break;
            }
            case AND_OP_NODE: {
                this.visitAndOpNode((OperatorNodes.AndOpNode)exprNode);
                break;
            }
            case OR_OP_NODE: {
                this.visitOrOpNode((OperatorNodes.OrOpNode)exprNode);
                break;
            }
            case CONDITIONAL_OP_NODE: {
                this.visitConditionalOpNode((OperatorNodes.ConditionalOpNode)exprNode);
                break;
            }
            case FUNCTION_NODE: {
                this.visitFunctionNode((FunctionNode)exprNode);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected void visitChildren(ExprNode.ParentExprNode parentExprNode) {
        this.visitChildren(parentExprNode);
    }

    protected void visitChildrenAllowingConcurrentModification(ExprNode.ParentExprNode parentExprNode) {
        this.visitChildrenAllowingConcurrentModification(parentExprNode);
    }

    protected void visitExprRootNode(ExprRootNode<?> exprRootNode) {
        this.visitExprNode(exprRootNode);
    }

    protected void visitNullNode(NullNode nullNode) {
        this.visitPrimitiveNode(nullNode);
    }

    protected void visitBooleanNode(BooleanNode booleanNode) {
        this.visitPrimitiveNode(booleanNode);
    }

    protected void visitIntegerNode(IntegerNode integerNode) {
        this.visitPrimitiveNode(integerNode);
    }

    protected void visitFloatNode(FloatNode floatNode) {
        this.visitPrimitiveNode(floatNode);
    }

    protected void visitStringNode(StringNode stringNode) {
        this.visitPrimitiveNode(stringNode);
    }

    protected void visitPrimitiveNode(ExprNode.PrimitiveNode primitiveNode) {
        this.visitExprNode(primitiveNode);
    }

    protected void visitListLiteralNode(ListLiteralNode listLiteralNode) {
        this.visitExprNode(listLiteralNode);
    }

    protected void visitMapLiteralNode(MapLiteralNode mapLiteralNode) {
        this.visitExprNode(mapLiteralNode);
    }

    protected void visitVarNode(VarNode varNode) {
        this.visitExprNode(varNode);
    }

    protected void visitDataRefNode(DataRefNode dataRefNode) {
        this.visitExprNode(dataRefNode);
    }

    protected void visitDataRefKeyNode(DataRefKeyNode dataRefKeyNode) {
        this.visitExprNode(dataRefKeyNode);
    }

    protected void visitDataRefIndexNode(DataRefIndexNode dataRefIndexNode) {
        this.visitExprNode(dataRefIndexNode);
    }

    protected void visitGlobalNode(GlobalNode globalNode) {
        this.visitExprNode(globalNode);
    }

    protected void visitNegativeOpNode(OperatorNodes.NegativeOpNode negativeOpNode) {
        this.visitOperatorNode(negativeOpNode);
    }

    protected void visitNotOpNode(OperatorNodes.NotOpNode notOpNode) {
        this.visitOperatorNode(notOpNode);
    }

    protected void visitTimesOpNode(OperatorNodes.TimesOpNode timesOpNode) {
        this.visitOperatorNode(timesOpNode);
    }

    protected void visitDivideByOpNode(OperatorNodes.DivideByOpNode divideByOpNode) {
        this.visitOperatorNode(divideByOpNode);
    }

    protected void visitModOpNode(OperatorNodes.ModOpNode modOpNode) {
        this.visitOperatorNode(modOpNode);
    }

    protected void visitPlusOpNode(OperatorNodes.PlusOpNode plusOpNode) {
        this.visitOperatorNode(plusOpNode);
    }

    protected void visitMinusOpNode(OperatorNodes.MinusOpNode minusOpNode) {
        this.visitOperatorNode(minusOpNode);
    }

    protected void visitLessThanOpNode(OperatorNodes.LessThanOpNode lessThanOpNode) {
        this.visitOperatorNode(lessThanOpNode);
    }

    protected void visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode greaterThanOpNode) {
        this.visitOperatorNode(greaterThanOpNode);
    }

    protected void visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode lessThanOrEqualOpNode) {
        this.visitOperatorNode(lessThanOrEqualOpNode);
    }

    protected void visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode greaterThanOrEqualOpNode) {
        this.visitOperatorNode(greaterThanOrEqualOpNode);
    }

    protected void visitEqualOpNode(OperatorNodes.EqualOpNode equalOpNode) {
        this.visitOperatorNode(equalOpNode);
    }

    protected void visitNotEqualOpNode(OperatorNodes.NotEqualOpNode notEqualOpNode) {
        this.visitOperatorNode(notEqualOpNode);
    }

    protected void visitAndOpNode(OperatorNodes.AndOpNode andOpNode) {
        this.visitOperatorNode(andOpNode);
    }

    protected void visitOrOpNode(OperatorNodes.OrOpNode orOpNode) {
        this.visitOperatorNode(orOpNode);
    }

    protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode conditionalOpNode) {
        this.visitOperatorNode(conditionalOpNode);
    }

    protected void visitOperatorNode(ExprNode.OperatorNode operatorNode) {
        this.visitExprNode(operatorNode);
    }

    protected void visitFunctionNode(FunctionNode functionNode) {
        this.visitExprNode(functionNode);
    }

    protected void visitExprNode(ExprNode exprNode) {
        throw new UnsupportedOperationException();
    }
}

