/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.collect.Maps;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.restricted.CollectionData;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SoyMapData
extends CollectionData {
    private final Map<String, SoyData> map;

    public SoyMapData() {
        this.map = Maps.newHashMap();
    }

    public SoyMapData(Map<String, ?> map) {
        this.map = Maps.newHashMapWithExpectedSize((int)map.size());
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String string;
            try {
                string = entry.getKey();
            }
            catch (ClassCastException classCastException) {
                throw new SoyDataException("Attempting to convert a map with non-string key to Soy data (key type " + entry.getKey().getClass().getName() + ").");
            }
            Object obj = entry.getValue();
            try {
                this.map.put(string, SoyData.createFromExistingData(obj));
            }
            catch (SoyDataException soyDataException) {
                soyDataException.prependKeyToDataPath(string);
                throw soyDataException;
            }
        }
    }

    public SoyMapData(Object ... objectArray) {
        this();
        this.put(objectArray);
    }

    public Map<String, SoyData> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public Set<String> getKeys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public String toString() {
        return this.toStringHelper(this.map);
    }

    protected String toStringHelper(Map<String, SoyData> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        boolean bl = true;
        for (Map.Entry<String, SoyData> entry : map.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue().toString());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public boolean toBoolean() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public void putSingle(String string, SoyData soyData) {
        this.map.put(string, soyData);
    }

    @Override
    public void removeSingle(String string) {
        this.map.remove(string);
    }

    @Override
    public SoyData getSingle(String string) {
        return this.map.get(string);
    }
}

