/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bidifunctions;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunctionUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaRuntimeFunctionUtils;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuFunction;
import java.util.List;
import java.util.Set;

@Singleton
class BidiMarkAfterFunction
extends SoyAbstractTofuFunction
implements SoyJsSrcFunction,
SoyJavaSrcFunction {
    private final Provider<BidiGlobalDir> bidiGlobalDirProvider;

    @Inject
    BidiMarkAfterFunction(Provider<BidiGlobalDir> provider) {
        this.bidiGlobalDirProvider = provider;
    }

    @Override
    public String getName() {
        return "bidiMarkAfter";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1, (Object)2);
    }

    @Override
    public SoyData compute(List<SoyData> list) {
        String string = list.get(0).stringValue();
        boolean bl = list.size() == 2 ? list.get(1).booleanValue() : false;
        int n = ((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getStaticValue();
        return SoyJavaRuntimeFunctionUtils.toSoyData(SoyBidiUtils.getBidiFormatter(n).markAfter(string, bl));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> list) {
        JsExpr jsExpr = list.get(0);
        JsExpr jsExpr2 = list.size() == 2 ? list.get(1) : null;
        String string = "soy.$$bidiMarkAfter(" + ((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet() + ", " + jsExpr.getText() + (jsExpr2 != null ? ", " + jsExpr2.getText() : "") + ")";
        return new JsExpr(string, Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr computeForJavaSrc(List<JavaExpr> list) {
        JavaExpr javaExpr = list.get(0);
        JavaExpr javaExpr2 = list.size() == 2 ? list.get(1) : null;
        String string = SoyBidiUtils.class.getName() + ".getBidiFormatter(" + ((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet() + ").markAfter";
        return SoyJavaSrcFunctionUtils.toStringJavaExpr(JavaCodeUtils.genNewStringData(JavaCodeUtils.genFunctionCall(string, JavaCodeUtils.genCoerceString(javaExpr), javaExpr2 != null ? JavaCodeUtils.genCoerceBoolean(javaExpr2) : "false")));
    }
}

