/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bidifunctions;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunctionUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaRuntimeFunctionUtils;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuFunction;
import java.util.List;
import java.util.Set;

@Singleton
class BidiGlobalDirFunction
extends SoyAbstractTofuFunction
implements SoyJsSrcFunction,
SoyJavaSrcFunction {
    private final Provider<BidiGlobalDir> bidiGlobalDirProvider;

    @Inject
    BidiGlobalDirFunction(Provider<BidiGlobalDir> provider) {
        this.bidiGlobalDirProvider = provider;
    }

    @Override
    public String getName() {
        return "bidiGlobalDir";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public SoyData compute(List<SoyData> list) {
        return SoyJavaRuntimeFunctionUtils.toSoyData(((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getStaticValue());
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> list) {
        BidiGlobalDir bidiGlobalDir = (BidiGlobalDir)this.bidiGlobalDirProvider.get();
        return new JsExpr(((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet(), bidiGlobalDir.isStaticValue() ? Integer.MAX_VALUE : Operator.CONDITIONAL.getPrecedence());
    }

    @Override
    public JavaExpr computeForJavaSrc(List<JavaExpr> list) {
        return SoyJavaSrcFunctionUtils.toIntegerJavaExpr(JavaCodeUtils.genNewIntegerData(((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet()));
    }
}

