/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bididirectives;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContentOperator;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunctionUtils;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuPrintDirective;
import java.util.List;
import java.util.Set;

@Singleton
public class BidiSpanWrapDirective
extends SoyAbstractTofuPrintDirective
implements SoyJsSrcPrintDirective,
SoyJavaSrcPrintDirective,
SanitizedContentOperator {
    private final Provider<BidiGlobalDir> bidiGlobalDirProvider;

    @Inject
    BidiSpanWrapDirective(Provider<BidiGlobalDir> provider) {
        this.bidiGlobalDirProvider = provider;
    }

    @Override
    public String getName() {
        return "|bidiSpanWrap";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    public String apply(SoyData soyData, List<SoyData> list) {
        boolean bl = true;
        return SoyBidiUtils.getBidiFormatter(((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getStaticValue()).spanWrap(soyData.toString(), bl);
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr jsExpr, List<JsExpr> list) {
        String string = ((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet();
        return new JsExpr("soy.$$bidiSpanWrap(" + string + ", " + jsExpr.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr applyForJavaSrc(JavaExpr javaExpr, List<JavaExpr> list) {
        String string = SoyBidiUtils.class.getName() + ".getBidiFormatter(" + ((BidiGlobalDir)this.bidiGlobalDirProvider.get()).getCodeSnippet() + ").spanWrap";
        return SoyJavaSrcFunctionUtils.toStringJavaExpr(JavaCodeUtils.genNewStringData(JavaCodeUtils.genFunctionCall(string, JavaCodeUtils.genCoerceString(javaExpr), "true")));
    }

    @Override
    public SanitizedContent.ContentKind getContentKind() {
        return SanitizedContent.ContentKind.HTML;
    }
}

