/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunctionUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsCodeUtils;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaRuntimeFunctionUtils;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuFunction;
import java.util.List;
import java.util.Set;

@Singleton
class RandomIntFunction
extends SoyAbstractTofuFunction
implements SoyJsSrcFunction,
SoyJavaSrcFunction {
    @Inject
    RandomIntFunction() {
    }

    @Override
    public String getName() {
        return "randomInt";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1);
    }

    @Override
    public SoyData compute(List<SoyData> list) {
        SoyData soyData = list.get(0);
        return SoyJavaRuntimeFunctionUtils.toSoyData((int)Math.floor(Math.random() * (double)soyData.integerValue()));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> list) {
        JsExpr jsExpr = list.get(0);
        JsExpr jsExpr2 = new JsExpr("Math.random()", Integer.MAX_VALUE);
        JsExpr jsExpr3 = SoyJsCodeUtils.genJsExprUsingSoySyntax(Operator.TIMES, Lists.newArrayList((Object[])new JsExpr[]{jsExpr2, jsExpr}));
        return new JsExpr("Math.floor(" + jsExpr3.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr computeForJavaSrc(List<JavaExpr> list) {
        JavaExpr javaExpr = list.get(0);
        return SoyJavaSrcFunctionUtils.toIntegerJavaExpr(JavaCodeUtils.genNewIntegerData("(int) Math.floor(Math.random() * " + JavaCodeUtils.genIntegerValue(javaExpr) + ")"));
    }
}

