/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaRuntimeFunctionUtils;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuFunction;
import java.util.List;
import java.util.Set;

@Singleton
@SoyPureFunction
class MaxFunction
extends SoyAbstractTofuFunction
implements SoyJsSrcFunction,
SoyJavaSrcFunction {
    @Inject
    MaxFunction() {
    }

    @Override
    public String getName() {
        return "max";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)2);
    }

    @Override
    public SoyData compute(List<SoyData> list) {
        SoyData soyData = list.get(0);
        SoyData soyData2 = list.get(1);
        if (soyData instanceof IntegerData && soyData2 instanceof IntegerData) {
            return SoyJavaRuntimeFunctionUtils.toSoyData(Math.max(soyData.integerValue(), soyData2.integerValue()));
        }
        return SoyJavaRuntimeFunctionUtils.toSoyData(Math.max(soyData.numberValue(), soyData2.numberValue()));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> list) {
        JsExpr jsExpr = list.get(0);
        JsExpr jsExpr2 = list.get(1);
        return new JsExpr("Math.max(" + jsExpr.getText() + ", " + jsExpr2.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr computeForJavaSrc(List<JavaExpr> list) {
        JavaExpr javaExpr = list.get(0);
        JavaExpr javaExpr2 = list.get(1);
        return JavaCodeUtils.genJavaExprForNumberToNumberBinaryFunction("Math.max", "$$max", javaExpr, javaExpr2);
    }
}

