/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunction;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcFunctionUtils;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaRuntimeFunctionUtils;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuFunction;
import java.util.List;
import java.util.Set;

@Singleton
@SoyPureFunction
class CeilingFunction
extends SoyAbstractTofuFunction
implements SoyJsSrcFunction,
SoyJavaSrcFunction {
    @Inject
    CeilingFunction() {
    }

    @Override
    public String getName() {
        return "ceiling";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1);
    }

    @Override
    public SoyData compute(List<SoyData> list) {
        SoyData soyData = list.get(0);
        if (soyData instanceof IntegerData) {
            return soyData;
        }
        return SoyJavaRuntimeFunctionUtils.toSoyData((int)Math.ceil(soyData.floatValue()));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> list) {
        JsExpr jsExpr = list.get(0);
        return new JsExpr("Math.ceil(" + jsExpr.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr computeForJavaSrc(List<JavaExpr> list) {
        JavaExpr javaExpr = list.get(0);
        return SoyJavaSrcFunctionUtils.toIntegerJavaExpr(JavaCodeUtils.genNewIntegerData("(int) Math.ceil(" + JavaCodeUtils.genNumberValue(javaExpr) + ")"));
    }
}

