/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicdirectives;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SoyData;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.javasrc.restricted.JavaCodeUtils;
import com.google.template.soy.javasrc.restricted.JavaExpr;
import com.google.template.soy.javasrc.restricted.SoyJavaSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.tofu.restricted.SoyAbstractTofuPrintDirective;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TruncateDirective
extends SoyAbstractTofuPrintDirective
implements SoyJsSrcPrintDirective,
SoyJavaSrcPrintDirective {
    @Inject
    public TruncateDirective() {
    }

    @Override
    public String getName() {
        return "|truncate";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1, (Object)2);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    public String apply(SoyData soyData, List<SoyData> list) {
        boolean bl;
        int n;
        try {
            n = list.get(0).integerValue();
        }
        catch (SoyDataException soyDataException) {
            throw new IllegalArgumentException("Could not parse first parameter of '|truncate' as integer (value was \"" + list.get(0).stringValue() + "\").");
        }
        String string = soyData.toString();
        if (string.length() <= n) {
            return string;
        }
        if (list.size() == 2) {
            try {
                bl = list.get(1).booleanValue();
            }
            catch (SoyDataException soyDataException) {
                throw new IllegalArgumentException("Could not parse second parameter of '|truncate' as boolean.");
            }
        } else {
            bl = true;
        }
        if (bl) {
            if (n > 3) {
                n -= 3;
            } else {
                bl = false;
            }
        }
        if (Character.isHighSurrogate(string.charAt(n - 1)) && Character.isLowSurrogate(string.charAt(n))) {
            --n;
        }
        string = string.substring(0, n);
        if (bl) {
            string = string + "...";
        }
        return string;
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr jsExpr, List<JsExpr> list) {
        String string = list.get(0).getText();
        String string2 = list.size() == 2 ? list.get(1).getText() : "true";
        return new JsExpr("soy.$$truncate(" + jsExpr.getText() + ", " + string + ", " + string2 + ")", Integer.MAX_VALUE);
    }

    @Override
    public JavaExpr applyForJavaSrc(JavaExpr javaExpr, List<JavaExpr> list) {
        String string = JavaCodeUtils.genCoerceString(javaExpr);
        String string2 = JavaCodeUtils.genIntegerValue(list.get(0));
        String string3 = list.size() == 2 ? JavaCodeUtils.genBooleanValue(list.get(1)) : "true";
        return new JavaExpr(JavaCodeUtils.genFunctionCall("com.google.template.soy.javasrc.codedeps.SoyUtils.$$truncate", string, string2, string3), String.class, Integer.MAX_VALUE);
    }
}

