/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basetree;

import com.google.common.collect.Lists;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.ParentNode;
import java.util.ArrayList;
import java.util.List;

public final class MixinParentNode<N extends Node> {
    protected static final String SPACES = "                                        ";
    private final ParentNode<N> master;
    private final List<N> children;
    private Boolean needsEnvFrameDuringInterp;

    public MixinParentNode(ParentNode<N> parentNode) {
        this.master = parentNode;
        this.needsEnvFrameDuringInterp = null;
        this.children = Lists.newArrayList();
    }

    public MixinParentNode(MixinParentNode<N> mixinParentNode, ParentNode<N> parentNode) {
        this.master = parentNode;
        this.needsEnvFrameDuringInterp = mixinParentNode.needsEnvFrameDuringInterp;
        this.children = Lists.newArrayListWithCapacity((int)mixinParentNode.children.size());
        for (Node node : mixinParentNode.children) {
            Node node2 = node.clone();
            this.children.add(node2);
            node2.setParent(this.master);
        }
    }

    public void setNeedsEnvFrameDuringInterp(Boolean bl) {
        this.needsEnvFrameDuringInterp = bl;
    }

    public Boolean needsEnvFrameDuringInterp() {
        return this.needsEnvFrameDuringInterp;
    }

    public int numChildren() {
        return this.children.size();
    }

    public N getChild(int n) {
        return (N)((Node)this.children.get(n));
    }

    public int getChildIndex(N n) {
        return this.children.indexOf(n);
    }

    public List<N> getChildren() {
        return this.children;
    }

    public void addChild(N n) {
        this.children.add(n);
        n.setParent(this.master);
    }

    public void addChild(int n, N n2) {
        this.children.add(n, n2);
        n2.setParent(this.master);
    }

    public void removeChild(int n) {
        Node node = (Node)this.children.remove(n);
        node.setParent(null);
    }

    public void removeChild(N n) {
        this.children.remove(n);
        n.setParent(null);
    }

    public void replaceChild(int n, N n2) {
        Node node = (Node)this.children.set(n, n2);
        node.setParent(null);
        n2.setParent(this.master);
    }

    public void replaceChild(N n, N n2) {
        this.replaceChild((N)this.getChildIndex(n), n2);
    }

    public void clearChildren() {
        this.children.clear();
    }

    public void addChildren(List<? extends N> list) {
        for (Node node : list) {
            this.addChild(node);
        }
    }

    public void addChildren(int n, List<? extends N> list) {
        ArrayList arrayList = Lists.newArrayList(this.children);
        int n2 = this.children.size();
        for (int i = n2 - 1; i >= n; --i) {
            this.removeChild(i);
        }
        this.addChildren(list);
        this.addChildren(arrayList.subList(n, n2));
    }

    public void appendSourceStringForChildren(StringBuilder stringBuilder) {
        for (Node node : this.children) {
            stringBuilder.append(node.toSourceString());
        }
    }

    public void appendTreeStringForChildren(StringBuilder stringBuilder, int n) {
        for (Node node : this.children) {
            stringBuilder.append(node.toTreeString(n + 3));
        }
    }

    public String toTreeString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SPACES.substring(0, n)).append("[").append(this.master.toString()).append("]\n");
        this.appendTreeStringForChildren(stringBuilder, n);
        return stringBuilder.toString();
    }
}

