/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import com.google.template.soy.base.StableSoyFileSupplier;
import com.google.template.soy.internal.base.Pair;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;

public interface SoyFileSupplier {
    public Pair<Reader, Version> open() throws IOException;

    public boolean hasChangedSince(Version var1);

    public String getPath();

    public static final class Factory {
        public static SoyFileSupplier create(InputSupplier<? extends Reader> inputSupplier, String string) {
            return new StableSoyFileSupplier(inputSupplier, string);
        }

        public static SoyFileSupplier create(File file) {
            return Factory.create((InputSupplier<? extends Reader>)Files.newReaderSupplier((File)file, (Charset)Charsets.UTF_8), file.getPath());
        }

        public static SoyFileSupplier create(URL uRL, String string) {
            return Factory.create((InputSupplier<? extends Reader>)Resources.newReaderSupplier((URL)uRL, (Charset)Charsets.UTF_8), string);
        }

        public static SoyFileSupplier create(URL uRL) {
            return Factory.create((InputSupplier<? extends Reader>)Resources.newReaderSupplier((URL)uRL, (Charset)Charsets.UTF_8), uRL.toString());
        }

        public static SoyFileSupplier create(CharSequence charSequence, String string) {
            return Factory.create((InputSupplier<? extends Reader>)CharStreams.newReaderSupplier((String)((Object)charSequence).toString()), string);
        }

        private Factory() {
        }
    }

    public static interface Version {
        public static final Version STABLE_VERSION = new Version(){};

        public boolean equals(Object var1);
    }
}

