/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base;

import com.google.common.base.Preconditions;

public class IndentedLinesBuilder
implements CharSequence,
Appendable {
    private static final String SPACES = "                        ";
    private static final int MAX_INDENT_LEN = 24;
    private final StringBuilder sb = new StringBuilder();
    private final int indentIncrementLen;
    private int indentLen;
    private String indent;

    public IndentedLinesBuilder(int n) {
        this.indentIncrementLen = n;
        this.indentLen = 0;
        this.indent = "";
    }

    public IndentedLinesBuilder(int n, int n2) {
        this.indentIncrementLen = n;
        this.indentLen = n2;
        Preconditions.checkState((0 <= this.indentLen && this.indentLen <= 24 ? 1 : 0) != 0);
        this.indent = SPACES.substring(0, this.indentLen);
    }

    public StringBuilder sb() {
        return this.sb;
    }

    public int getIndentIncrementLen() {
        return this.indentIncrementLen;
    }

    public int getCurrIndentLen() {
        return this.indentLen;
    }

    public void increaseIndent() {
        this.increaseIndent(1);
    }

    public void increaseIndent(int n) {
        this.indentLen += n * this.indentIncrementLen;
        Preconditions.checkState((0 <= this.indentLen && this.indentLen <= 24 ? 1 : 0) != 0);
        this.indent = SPACES.substring(0, this.indentLen);
    }

    public void decreaseIndent() {
        this.decreaseIndent(1);
    }

    public void decreaseIndent(int n) {
        this.indentLen -= n * this.indentIncrementLen;
        Preconditions.checkState((0 <= this.indentLen && this.indentLen <= 24 ? 1 : 0) != 0);
        this.indent = SPACES.substring(0, this.indentLen);
    }

    public void setIndentLen(int n) {
        this.indentLen = n;
        Preconditions.checkState((0 <= n && n <= 24 ? 1 : 0) != 0);
        this.indent = SPACES.substring(0, n);
    }

    public void appendLine(String ... stringArray) {
        if (stringArray.length > 0) {
            this.sb.append(this.indent);
        }
        this.appendParts(stringArray);
        this.appendLineEnd();
    }

    public IndentedLinesBuilder appendParts(String ... stringArray) {
        for (String string : stringArray) {
            this.sb.append(string);
        }
        return this;
    }

    public void appendLine(Object ... objectArray) {
        if (objectArray.length > 0) {
            this.sb.append(this.indent);
        }
        this.appendParts(objectArray);
        this.appendLineEnd();
    }

    public IndentedLinesBuilder appendParts(Object ... objectArray) {
        for (Object object : objectArray) {
            this.sb.append(object);
        }
        return this;
    }

    public IndentedLinesBuilder appendIndent() {
        this.sb.append(this.indent);
        return this;
    }

    public void appendLineEnd() {
        this.sb.append('\n');
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public char charAt(int n) {
        return this.sb.charAt(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.sb.subSequence(n, n2);
    }

    @Override
    public IndentedLinesBuilder append(CharSequence charSequence) {
        this.sb.append(charSequence);
        return this;
    }

    @Override
    public IndentedLinesBuilder append(CharSequence charSequence, int n, int n2) {
        this.sb.append(charSequence, n, n2);
        return this;
    }

    @Override
    public IndentedLinesBuilder append(char c) {
        this.sb.append(c);
        return this;
    }
}

