/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.data.internalutils.DataUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.TokenMgrError;
import com.google.template.soy.exprtree.DataRefNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.internal.base.Pair;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SoyUtils {
    private static final Pattern COMPILE_TIME_GLOBAL_LINE = Pattern.compile("([a-zA-Z_][a-zA-Z_0-9.]*) \\s* = \\s* (.+)", 4);

    private SoyUtils() {
    }

    public static void generateCompileTimeGlobalsFile(Map<String, ?> map, Appendable appendable) throws IOException {
        ImmutableMap<String, PrimitiveData> immutableMap = DataUtils.convertCompileTimeGlobalsMap(map);
        for (Map.Entry entry : immutableMap.entrySet()) {
            String string = DataUtils.convertPrimitiveDataToExpr((PrimitiveData)entry.getValue()).toSourceString();
            appendable.append((CharSequence)entry.getKey()).append(" = ").append(string).append("\n");
        }
    }

    public static void generateCompileTimeGlobalsFile(Map<String, ?> map, File file) throws IOException {
        BufferedWriter bufferedWriter = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        SoyUtils.generateCompileTimeGlobalsFile(map, bufferedWriter);
        bufferedWriter.close();
    }

    public static ImmutableMap<String, PrimitiveData> parseCompileTimeGlobals(InputSupplier<? extends Reader> inputSupplier) throws IOException, SoySyntaxException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)0);
        BufferedReader bufferedReader = new BufferedReader((Reader)inputSupplier.getInput());
        CharSequence charSequence = bufferedReader.readLine();
        while (charSequence != null) {
            block12: {
                if (!((String)charSequence).startsWith("//") && ((String)charSequence).trim().length() != 0) {
                    Matcher matcher = COMPILE_TIME_GLOBAL_LINE.matcher(charSequence);
                    if (!matcher.matches()) {
                        arrayList.add(Pair.of(CompileTimeGlobalsFileError.INVALID_FORMAT, charSequence));
                    } else {
                        PrimitiveData primitiveData;
                        Object object = matcher.group(1);
                        String string = matcher.group(2).trim();
                        try {
                            Node node = new ExpressionParser(string).parseExpression().getChild(0);
                            if (!(node instanceof ExprNode.PrimitiveNode)) {
                                if (node instanceof GlobalNode || node instanceof DataRefNode) {
                                    arrayList.add(Pair.of(CompileTimeGlobalsFileError.INVALID_VALUE, charSequence));
                                } else {
                                    arrayList.add(Pair.of(CompileTimeGlobalsFileError.NON_PRIMITIVE_VALUE, charSequence));
                                }
                                break block12;
                            }
                            primitiveData = DataUtils.convertPrimitiveExprToData((ExprNode.PrimitiveNode)node);
                        }
                        catch (TokenMgrError tokenMgrError) {
                            arrayList.add(Pair.of(CompileTimeGlobalsFileError.INVALID_VALUE, charSequence));
                            break block12;
                        }
                        catch (ParseException parseException) {
                            arrayList.add(Pair.of(CompileTimeGlobalsFileError.INVALID_VALUE, charSequence));
                            break block12;
                        }
                        builder.put(object, (Object)primitiveData);
                    }
                }
            }
            charSequence = bufferedReader.readLine();
        }
        if (arrayList.size() > 0) {
            charSequence = new StringBuilder("Compile-time globals file contains the following errors:\n");
            for (Object object : arrayList) {
                ((StringBuilder)charSequence).append("[").append(String.format("%-19s", ((CompileTimeGlobalsFileError)((Object)((Pair)object).first)).toString())).append("] ").append((String)((Pair)object).second).append("\n");
            }
            throw new SoySyntaxException(((StringBuilder)charSequence).toString());
        }
        return builder.build();
    }

    private static enum CompileTimeGlobalsFileError {
        INVALID_FORMAT("Invalid line format"),
        INVALID_VALUE("Invalid value"),
        NON_PRIMITIVE_VALUE("Non-primitive value");

        private final String errorString;

        private CompileTimeGlobalsFileError(String string2) {
            this.errorString = string2;
        }

        public String toString() {
            return this.errorString;
        }
    }
}

