/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.InputSupplier;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.util.Providers;
import com.google.template.soy.GuiceInitializer;
import com.google.template.soy.base.SoyFileSupplier;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.base.VolatileSoyFileSupplier;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.javasrc.SoyJavaSrcOptions;
import com.google.template.soy.javasrc.SoyTemplateRuntime;
import com.google.template.soy.javasrc.SoyTemplateRuntimes;
import com.google.template.soy.javasrc.dyncompile.SoyToJavaDynamicCompiler;
import com.google.template.soy.javasrc.internal.JavaSrcMain;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.JsSrcMain;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.msgs.internal.ExtractMsgsVisitor;
import com.google.template.soy.parseinfo.passes.GenerateParseInfoVisitor;
import com.google.template.soy.parsepasses.ChangeCallsToPassAllDataVisitor;
import com.google.template.soy.parsepasses.CheckFunctionCallsVisitor;
import com.google.template.soy.parsepasses.HandleCssCommandVisitor;
import com.google.template.soy.parsepasses.PerformAutoescapeVisitor;
import com.google.template.soy.parsepasses.contextautoesc.ContextualAutoescaper;
import com.google.template.soy.parsepasses.contextautoesc.DerivedTemplateUtils;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.sharedpasses.ClearSoyDocStringsVisitor;
import com.google.template.soy.sharedpasses.SubstituteGlobalsVisitor;
import com.google.template.soy.sharedpasses.opti.SimplifyVisitor;
import com.google.template.soy.soyparse.SoyFileSetParser;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.internal.BaseTofu;
import com.google.template.soy.xliffmsgplugin.XliffMsgPlugin;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class SoyFileSet {
    private static final Provider<SoyMsgBundleHandler> DEFAULT_SOY_MSG_BUNDLE_HANDLER_PROVIDER = Providers.of((Object)new SoyMsgBundleHandler(new XliffMsgPlugin()));
    private Provider<SoyMsgBundleHandler> msgBundleHandlerProvider = DEFAULT_SOY_MSG_BUNDLE_HANDLER_PROVIDER;
    private final BaseTofu.BaseTofuFactory baseTofuFactory;
    private final Provider<JsSrcMain> jsSrcMainProvider;
    private final Provider<JavaSrcMain> javaSrcMainProvider;
    private final PerformAutoescapeVisitor performAutoescapeVisitor;
    private final ContextualAutoescaper contextualAutoescaper;
    private final CheckFunctionCallsVisitor checkFunctionCallsVisitor;
    private final SimplifyVisitor simplifyVisitor;
    private final List<SoyFileSupplier> soyFileSuppliers;
    private final SoyGeneralOptions options;

    @Inject
    SoyFileSet(BaseTofu.BaseTofuFactory baseTofuFactory, Provider<JsSrcMain> provider, Provider<JavaSrcMain> provider2, PerformAutoescapeVisitor performAutoescapeVisitor, ContextualAutoescaper contextualAutoescaper, SimplifyVisitor simplifyVisitor, CheckFunctionCallsVisitor checkFunctionCallsVisitor, @Assisted List<SoyFileSupplier> list, @Assisted SoyGeneralOptions soyGeneralOptions) {
        this.baseTofuFactory = baseTofuFactory;
        this.jsSrcMainProvider = provider;
        this.javaSrcMainProvider = provider2;
        this.performAutoescapeVisitor = performAutoescapeVisitor;
        this.contextualAutoescaper = contextualAutoescaper;
        this.simplifyVisitor = simplifyVisitor;
        this.checkFunctionCallsVisitor = checkFunctionCallsVisitor;
        Preconditions.checkArgument((list.size() > 0 ? 1 : 0) != 0, (Object)"Must have non-zero number of input Soy files.");
        this.soyFileSuppliers = list;
        this.options = soyGeneralOptions;
    }

    @Inject(optional=true)
    void setMsgBundleHandlerProvider(Provider<SoyMsgBundleHandler> provider) {
        this.msgBundleHandlerProvider = provider;
    }

    @VisibleForTesting
    List<SoyFileSupplier> getSoyFileSuppliersForTesting() {
        return this.soyFileSuppliers;
    }

    @VisibleForTesting
    SoyGeneralOptions getOptionsForTesting() {
        return this.options;
    }

    public ImmutableMap<String, String> generateParseInfo(String string, String string2) throws SoySyntaxException {
        SoyFileSetNode soyFileSetNode = new SoyFileSetParser(this.soyFileSuppliers).parse();
        return new GenerateParseInfoVisitor(string, string2).exec(soyFileSetNode);
    }

    public SoyMsgBundle extractMsgs() throws SoySyntaxException {
        SoyFileSetNode soyFileSetNode = new SoyFileSetParser(this.soyFileSuppliers).setDoEnforceSyntaxVersionV2(false).setDoCheckOverrides(false).parse();
        return new ExtractMsgsVisitor().exec(soyFileSetNode);
    }

    public SoyTofu compileToJavaObj() throws SoySyntaxException {
        return this.compileToJavaObj(false);
    }

    public SoyTofu compileToJavaObj(boolean bl) throws SoySyntaxException {
        SoyFileSetNode soyFileSetNode = new SoyFileSetParser(this.soyFileSuppliers).parse();
        this.runMiddleendPasses(soyFileSetNode, true);
        new SubstituteGlobalsVisitor((Map<String, PrimitiveData>)this.options.getCompileTimeGlobals(), true).exec(soyFileSetNode);
        new ClearSoyDocStringsVisitor().exec(soyFileSetNode);
        return this.baseTofuFactory.create(soyFileSetNode, bl);
    }

    public SoyTemplateRuntimes compileToRuntimes(final String string, SoyJavaSrcOptions soyJavaSrcOptions, final SoyMsgBundle soyMsgBundle) {
        final SoyJavaSrcOptions soyJavaSrcOptions2 = new SoyJavaSrcOptions(soyJavaSrcOptions);
        soyJavaSrcOptions2.setCodeStyle(SoyJavaSrcOptions.CodeStyle.STRINGBUILDER);
        return new SoyTemplateRuntimes(){
            private List<SoyFileSupplier.Version> compiledVersions = null;
            private ImmutableMap<String, SoyTemplateRuntime> compiledTemplates;
            private final boolean isDynamic;
            {
                1 var5_5 = this;
                synchronized (var5_5) {
                    this.compile();
                    boolean bl = false;
                    for (SoyFileSupplier.Version version : this.compiledVersions) {
                        if (version == SoyFileSupplier.Version.STABLE_VERSION) continue;
                        bl = true;
                        break;
                    }
                    this.isDynamic = bl;
                }
            }

            @Override
            public SoyTemplateRuntime newRenderer(String string2) throws SoySyntaxException {
                if (this.isOutOfDate()) {
                    this.compile();
                }
                return (SoyTemplateRuntime)this.compiledTemplates.get((Object)string2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void compile() throws SoySyntaxException {
                Pair<SoyFileSetNode, List<SoyFileSupplier.Version>> pair = new SoyFileSetParser(SoyFileSet.this.soyFileSuppliers).parseWithVersions();
                SoyFileSetNode soyFileSetNode = (SoyFileSetNode)pair.first;
                SoyFileSet.this.runMiddleendPasses(soyFileSetNode, true);
                ImmutableMap<String, SoyTemplateRuntime> immutableMap = SoyToJavaDynamicCompiler.compile(string, SoyFileSet.this.compileFileSetToJavaSrc(soyFileSetNode, soyJavaSrcOptions2, soyMsgBundle));
                1 var4_4 = this;
                synchronized (var4_4) {
                    this.compiledTemplates = immutableMap;
                    this.compiledVersions = (List)pair.second;
                }
            }

            private boolean isOutOfDate() {
                if (this.isDynamic) {
                    int n = SoyFileSet.this.soyFileSuppliers.size();
                    for (int i = 0; i < n; ++i) {
                        if (!((SoyFileSupplier)SoyFileSet.this.soyFileSuppliers.get(i)).hasChangedSince(this.compiledVersions.get(i))) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public String compileToJavaSrc(SoyJavaSrcOptions soyJavaSrcOptions, SoyMsgBundle soyMsgBundle) {
        SoyFileSetNode soyFileSetNode = new SoyFileSetParser(this.soyFileSuppliers).parse();
        this.runMiddleendPasses(soyFileSetNode, true);
        return this.compileFileSetToJavaSrc(soyFileSetNode, soyJavaSrcOptions, soyMsgBundle);
    }

    private String compileFileSetToJavaSrc(SoyFileSetNode soyFileSetNode, SoyJavaSrcOptions soyJavaSrcOptions, SoyMsgBundle soyMsgBundle) {
        new SubstituteGlobalsVisitor((Map<String, PrimitiveData>)this.options.getCompileTimeGlobals(), true).exec(soyFileSetNode);
        return ((JavaSrcMain)this.javaSrcMainProvider.get()).genJavaSrc(soyFileSetNode, soyJavaSrcOptions, soyMsgBundle);
    }

    public List<String> compileToJsSrc(SoyJsSrcOptions soyJsSrcOptions, @Nullable SoyMsgBundle soyMsgBundle) throws SoySyntaxException {
        boolean bl = !soyJsSrcOptions.shouldAllowDeprecatedSyntax();
        SoyFileSetNode soyFileSetNode = new SoyFileSetParser(this.soyFileSuppliers).setDoEnforceSyntaxVersionV2(bl).parse();
        this.runMiddleendPasses(soyFileSetNode, bl);
        return ((JsSrcMain)this.jsSrcMainProvider.get()).genJsSrc(soyFileSetNode, soyJsSrcOptions, soyMsgBundle);
    }

    void compileToJsSrcFiles(String string, String string2, SoyJsSrcOptions soyJsSrcOptions, List<String> list, @Nullable String string3) throws SoySyntaxException, IOException {
        boolean bl = !soyJsSrcOptions.shouldAllowDeprecatedSyntax();
        SoyFileSetNode soyFileSetNode = new SoyFileSetParser(this.soyFileSuppliers).setDoEnforceSyntaxVersionV2(bl).parse();
        this.runMiddleendPasses(soyFileSetNode, bl);
        if (list.size() == 0) {
            ((JsSrcMain)this.jsSrcMainProvider.get()).genJsFiles(soyFileSetNode, soyJsSrcOptions, null, null, string, string2);
        } else {
            for (String string4 : list) {
                SoyFileSetNode soyFileSetNode2 = soyFileSetNode.clone();
                String string5 = JsSrcUtils.buildFilePath(string3, string4, null, string2);
                SoyMsgBundle soyMsgBundle = ((SoyMsgBundleHandler)this.msgBundleHandlerProvider.get()).createFromFile(new File(string5));
                if (soyMsgBundle.getLocaleString() == null && !string4.startsWith("en")) {
                    throw new IOException("Error opening or reading message file " + string5);
                }
                ((JsSrcMain)this.jsSrcMainProvider.get()).genJsFiles(soyFileSetNode2, soyJsSrcOptions, string4, soyMsgBundle, string, string2);
            }
        }
    }

    private void runMiddleendPasses(SoyFileSetNode soyFileSetNode, boolean bl) throws SoySyntaxException {
        new HandleCssCommandVisitor(this.options.getCssHandlingScheme()).exec(soyFileSetNode);
        if (this.options.getCompileTimeGlobals() != null) {
            new SubstituteGlobalsVisitor((Map<String, PrimitiveData>)this.options.getCompileTimeGlobals(), false).exec(soyFileSetNode);
        }
        this.checkFunctionCallsVisitor.setAllowExternallyDefinedFunctions(!bl);
        this.checkFunctionCallsVisitor.exec(soyFileSetNode);
        this.doContextualEscaping(soyFileSetNode);
        this.performAutoescapeVisitor.exec(soyFileSetNode);
        new ChangeCallsToPassAllDataVisitor().exec(soyFileSetNode);
        this.simplifyVisitor.exec(soyFileSetNode);
    }

    private void doContextualEscaping(SoyFileSetNode soyFileSetNode) throws SoySyntaxException {
        List<TemplateNode> list = this.contextualAutoescaper.rewrite(soyFileSetNode);
        if (!list.isEmpty()) {
            HashMap hashMap = Maps.newHashMap();
            for (SoyFileNode abstractSoyNode : soyFileSetNode.getChildren()) {
                for (TemplateNode templateNode : abstractSoyNode.getChildren()) {
                    String string = templateNode instanceof TemplateDelegateNode ? ((TemplateDelegateNode)templateNode).getDelTemplateName() : templateNode.getTemplateName();
                    hashMap.put(DerivedTemplateUtils.getBaseName(string), abstractSoyNode);
                }
            }
            for (TemplateNode templateNode : list) {
                String string = templateNode instanceof TemplateDelegateNode ? ((TemplateDelegateNode)templateNode).getDelTemplateName() : templateNode.getTemplateName();
                ((SoyFileNode)hashMap.get(DerivedTemplateUtils.getBaseName(string))).addChild(templateNode);
            }
        }
    }

    public static final class Builder {
        @Inject
        private static SoyFileSetFactory soyFileSetFactory = null;
        private final ImmutableList.Builder<SoyFileSupplier> listBuilder = ImmutableList.builder();
        private SoyGeneralOptions options;

        @Inject
        public Builder() {
            this(new SoyGeneralOptions());
        }

        public Builder(SoyGeneralOptions soyGeneralOptions) {
            this.options = soyGeneralOptions.clone();
            GuiceInitializer.initializeIfNecessary();
        }

        public SoyFileSet build() {
            return soyFileSetFactory.create((List<SoyFileSupplier>)this.listBuilder.build(), this.options);
        }

        public Builder add(InputSupplier<? extends Reader> inputSupplier, String string) {
            this.listBuilder.add((Object)SoyFileSupplier.Factory.create(inputSupplier, string));
            return this;
        }

        public Builder add(File file) {
            this.listBuilder.add((Object)SoyFileSupplier.Factory.create(file));
            return this;
        }

        public Builder addVolatile(File file) {
            this.listBuilder.add((Object)new VolatileSoyFileSupplier(file));
            return this;
        }

        public Builder add(URL uRL, String string) {
            this.listBuilder.add((Object)SoyFileSupplier.Factory.create(uRL, string));
            return this;
        }

        public Builder add(URL uRL) {
            this.listBuilder.add((Object)SoyFileSupplier.Factory.create(uRL));
            return this;
        }

        public Builder add(CharSequence charSequence, String string) {
            this.listBuilder.add((Object)SoyFileSupplier.Factory.create(charSequence, string));
            return this;
        }

        public Builder setCssHandlingScheme(SoyGeneralOptions.CssHandlingScheme cssHandlingScheme) {
            this.options.setCssHandlingScheme(cssHandlingScheme);
            return this;
        }

        public Builder setCompileTimeGlobals(Map<String, ?> map) {
            this.options.setCompileTimeGlobals(map);
            return this;
        }

        public Builder setCompileTimeGlobals(File file) throws IOException {
            this.options.setCompileTimeGlobals(file);
            return this;
        }

        public Builder setCompileTimeGlobals(URL uRL) throws IOException {
            this.options.setCompileTimeGlobals(uRL);
            return this;
        }
    }

    static interface SoyFileSetFactory {
        public SoyFileSet create(List<SoyFileSupplier> var1, SoyGeneralOptions var2);
    }
}

