/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.httpclient;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.data.Protocol;
import org.restlet.engine.Engine;
import org.restlet.engine.adapter.ClientCall;
import org.restlet.engine.ssl.SslContextFactory;
import org.restlet.engine.ssl.SslUtils;
import org.restlet.engine.util.ReferenceUtils;
import org.restlet.ext.httpclient.internal.HttpIdleConnectionReaper;
import org.restlet.ext.httpclient.internal.HttpMethodCall;
import org.restlet.ext.httpclient.internal.IgnoreCookieSpecFactory;

public class HttpClientHelper
extends org.restlet.engine.adapter.HttpClientHelper {
    private volatile DefaultHttpClient httpClient = null;
    private volatile HttpIdleConnectionReaper idleConnectionReaper;

    public HttpClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.HTTP);
        this.getProtocols().add(Protocol.HTTPS);
    }

    protected void configure(DefaultHttpClient httpClient) {
        if (this.getRetryHandler() != null) {
            try {
                HttpRequestRetryHandler retryHandler = (HttpRequestRetryHandler)Engine.loadClass(this.getRetryHandler()).newInstance();
                this.httpClient.setHttpRequestRetryHandler(retryHandler);
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "An error occurred during the instantiation of the retry handler.", e);
            }
        }
        CookieSpecRegistry csr = new CookieSpecRegistry();
        csr.register("ignore", new IgnoreCookieSpecFactory());
        this.httpClient.setCookieSpecs(csr);
    }

    protected void configure(HttpParams params) {
        ConnManagerParams.setMaxTotalConnections(params, this.getMaxTotalConnections());
        ConnManagerParams.setMaxConnectionsPerRoute(params, new ConnPerRouteBean(this.getMaxConnectionsPerHost()));
        HttpClientParams.setAuthenticating(params, false);
        HttpClientParams.setRedirecting(params, this.isFollowRedirects());
        HttpClientParams.setCookiePolicy(params, "ignore");
        HttpConnectionParams.setTcpNoDelay(params, this.getTcpNoDelay());
        HttpConnectionParams.setConnectionTimeout(params, this.getSocketConnectTimeoutMs());
        HttpConnectionParams.setSoTimeout(params, this.getSocketTimeout());
        String httpProxyHost = this.getProxyHost();
        if (httpProxyHost != null) {
            HttpHost proxy = new HttpHost(httpProxyHost, this.getProxyPort());
            params.setParameter("http.route.default-proxy", proxy);
        }
    }

    protected void configure(SchemeRegistry schemeRegistry) {
        schemeRegistry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));
        SSLSocketFactory sslSocketFactory = null;
        SslContextFactory sslContextFactory = SslUtils.getSslContextFactory(this);
        if (sslContextFactory != null) {
            try {
                SSLContext sslContext = sslContextFactory.createSslContext();
                sslSocketFactory = new SSLSocketFactory(sslContext);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create SSLContext.", e);
            }
        } else {
            sslSocketFactory = SSLSocketFactory.getSocketFactory();
        }
        if (this.getHostnameVerifier() != null) {
            try {
                X509HostnameVerifier hostnameVerifier = (X509HostnameVerifier)Engine.loadClass(this.getHostnameVerifier()).newInstance();
                sslSocketFactory.setHostnameVerifier(hostnameVerifier);
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "An error occurred during the instantiation of the hostname verifier.", e);
            }
        }
        schemeRegistry.register(new Scheme("https", 443, sslSocketFactory));
    }

    @Override
    public ClientCall create(Request request) {
        HttpMethodCall result = null;
        try {
            result = new HttpMethodCall(this, request.getMethod().toString(), ReferenceUtils.update(request.getResourceRef(), request).toString(), request.isEntityAvailable());
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to create the HTTP client call", ioe);
        }
        return result;
    }

    protected ClientConnectionManager createClientConnectionManager(HttpParams params, SchemeRegistry schemeRegistry) {
        return new ThreadSafeClientConnManager(params, schemeRegistry);
    }

    public String getHostnameVerifier() {
        return this.getHelpedParameters().getFirstValue("hostnameVerifier", null);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public long getIdleCheckInterval() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("idleCheckInterval", "0"));
    }

    public long getIdleTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("idleTimeout", "10000"));
    }

    public int getMaxConnectionsPerHost() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxConnectionsPerHost", "10"));
    }

    public int getMaxTotalConnections() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxTotalConnections", "20"));
    }

    public String getProxyHost() {
        return this.getHelpedParameters().getFirstValue("proxyHost", System.getProperty("http.proxyHost"));
    }

    public int getProxyPort() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("proxyPort", System.getProperty("http.proxyPort", "3128")));
    }

    public String getRetryHandler() {
        return this.getHelpedParameters().getFirstValue("retryHandler", null);
    }

    public int getSocketTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("socketTimeout", "0"));
    }

    public int getStopIdleTimeout() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("stopIdleTimeout", "1000"));
    }

    public boolean getTcpNoDelay() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("tcpNoDelay", "false"));
    }

    public boolean isFollowRedirects() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("followRedirects", "false"));
    }

    public void setIdleConnectionReaper(HttpIdleConnectionReaper connectionReaper) {
        this.idleConnectionReaper = connectionReaper;
    }

    @Override
    public void start() throws Exception {
        super.start();
        BasicHttpParams params = new BasicHttpParams();
        this.configure(params);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        this.configure(schemeRegistry);
        ClientConnectionManager connectionManager = this.createClientConnectionManager(params, schemeRegistry);
        this.httpClient = new DefaultHttpClient(connectionManager, params);
        this.configure(this.httpClient);
        if (this.idleConnectionReaper != null) {
            this.idleConnectionReaper.stop();
        }
        this.idleConnectionReaper = new HttpIdleConnectionReaper(this.httpClient, this.getIdleCheckInterval(), this.getIdleTimeout());
        this.getLogger().info("Starting the Apache HTTP client");
    }

    @Override
    public void stop() throws Exception {
        if (this.idleConnectionReaper != null) {
            this.idleConnectionReaper.stop();
        }
        if (this.getHttpClient() != null) {
            this.getHttpClient().getConnectionManager().closeExpiredConnections();
            this.getHttpClient().getConnectionManager().closeIdleConnections(this.getStopIdleTimeout(), TimeUnit.MILLISECONDS);
            this.getHttpClient().getConnectionManager().shutdown();
            this.getLogger().info("Stopping the HTTP client");
        }
    }
}

