/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.ParallelizeByNodeIdStep;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ParallelizeByNodeIdStepTest {
    @Test
    public void shouldDetectABA() throws Throwable {
        StageControl control = (StageControl)Mockito.mock(StageControl.class);
        ParallelizeByNodeIdStep step = new ParallelizeByNodeIdStep(control, Configuration.DEFAULT);
        int batchSize = Configuration.DEFAULT.batchSize();
        Batch a = new Batch((Object[])new InputRelationship[batchSize]);
        this.setIds(a, 0L, 2L, batchSize * 2);
        Batch b = new Batch((Object[])new InputRelationship[batchSize]);
        this.setIds(b, 1L, 2L, batchSize * 2);
        Batch aa = new Batch((Object[])new InputRelationship[batchSize]);
        this.setIds(aa, 0L, 2L, batchSize * 2);
        Batch bb = new Batch((Object[])new InputRelationship[batchSize]);
        this.setIds(bb, 1L, 2L, batchSize * 2);
        BatchSender sender = (BatchSender)Mockito.mock(BatchSender.class);
        step.process((Object)a, sender);
        step.process((Object)b, sender);
        step.process((Object)aa, sender);
        step.process((Object)bb, sender);
        Assert.assertTrue((boolean)a.parallelizableWithPrevious);
        Assert.assertTrue((boolean)b.parallelizableWithPrevious);
        Assert.assertFalse((boolean)aa.parallelizableWithPrevious);
        Assert.assertTrue((boolean)bb.parallelizableWithPrevious);
    }

    private void setIds(Batch<?, ?> batch, long first, long stride, int count) {
        batch.ids = new long[count];
        long value = first;
        for (int i = 0; i < count; ++i) {
            batch.ids[i] = value;
            value += stride;
        }
        batch.sortedIds = (long[])batch.ids.clone();
        Arrays.sort(batch.sortedIds);
    }
}

