/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.bootclasspathrunner;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;

class RmiServer
implements AutoCloseable {
    private static Registry registry;
    private static int port;
    private List<String> boundNames = new ArrayList<String>();

    public RmiServer() {
        RmiServer.createRegistry();
    }

    private static synchronized void createRegistry() {
        while (registry == null) {
            try {
                registry = LocateRegistry.createRegistry(port);
            }
            catch (RemoteException e) {
                if (++port <= 5099) continue;
                throw new RuntimeException(e);
            }
        }
    }

    public int getPort() {
        return port;
    }

    public void export(String name, Remote remote) {
        try {
            Remote stub = UnicastRemoteObject.exportObject(remote, port);
            registry.rebind(name, stub);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        for (String name : registry.list()) {
            registry.unbind(name);
        }
    }

    static {
        port = 1099;
    }
}

