/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.tooling.GlobalGraphOperations;

public class DbRepresentation
implements Serializable {
    private final Map<Long, NodeRep> nodes = new TreeMap<Long, NodeRep>();
    private long highestNodeId;
    private long highestRelationshipId;

    public static DbRepresentation of(GraphDatabaseService db) {
        return DbRepresentation.of(db, true);
    }

    public static DbRepresentation of(GraphDatabaseService db, boolean includeIndexes) {
        try (Transaction ignore = db.beginTx();){
            DbRepresentation result = new DbRepresentation();
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
                NodeRep nodeRep = new NodeRep(db, node, includeIndexes);
                result.nodes.put(node.getId(), nodeRep);
                result.highestNodeId = Math.max(node.getId(), result.highestNodeId);
                result.highestRelationshipId = Math.max(nodeRep.highestRelationshipId, result.highestRelationshipId);
            }
            DbRepresentation dbRepresentation = result;
            return dbRepresentation;
        }
    }

    public static DbRepresentation of(File storeDir) {
        return DbRepresentation.of(storeDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbRepresentation of(File storeDir, boolean includeIndexes) {
        GraphDatabaseBuilder builder = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir.getPath());
        GraphDatabaseService db = builder.newGraphDatabase();
        try {
            DbRepresentation dbRepresentation = DbRepresentation.of(db, includeIndexes);
            return dbRepresentation;
        }
        finally {
            db.shutdown();
        }
    }

    public boolean equals(Object obj) {
        return this.compareWith((DbRepresentation)obj).isEmpty();
    }

    public Collection<String> compareWith(DbRepresentation other) {
        ArrayList<String> diffList = new ArrayList<String>();
        CollectionDiffReport diff = new CollectionDiffReport(diffList);
        for (NodeRep node : this.nodes.values()) {
            NodeRep otherNode = other.nodes.get(node.id);
            if (otherNode == null) {
                diff.add("I have node " + node.id + " which other don't");
                continue;
            }
            node.compareWith(otherNode, diff);
        }
        for (Long id : other.nodes.keySet()) {
            if (this.nodes.containsKey(id)) continue;
            diff.add("Other has node " + id + " which I don't");
        }
        return diffList;
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }

    public String toString() {
        return this.nodes.toString();
    }

    private static class CollectionDiffReport
    implements DiffReport {
        private final Collection<String> collection;

        public CollectionDiffReport(Collection<String> collection) {
            this.collection = collection;
        }

        @Override
        public void add(String report) {
            this.collection.add(report);
        }
    }

    private static interface DiffReport {
        public void add(String var1);
    }

    private static class PropertiesRep
    implements Serializable {
        private final Map<String, Serializable> props = new HashMap<String, Serializable>();
        private final String entityToString;
        private final long entityId;

        PropertiesRep(PropertyContainer entity, long id) {
            this.entityId = id;
            this.entityToString = entity.toString();
            for (String key : entity.getPropertyKeys()) {
                Serializable value = (Serializable)entity.getProperty(key, null);
                if (value == null) continue;
                if (value.getClass().isArray()) {
                    this.props.put(key, new ArrayList<Object>(Arrays.asList(IoPrimitiveUtils.asArray((Object)value))));
                    continue;
                }
                this.props.put(key, value);
            }
        }

        protected boolean compareWith(PropertiesRep other, DiffReport diff) {
            boolean equals = this.props.equals(other.props);
            if (!equals) {
                diff.add("Properties diff for " + this.entityToString + " mine:" + this.props + ", other:" + other.props);
            }
            return equals;
        }

        public int hashCode() {
            return this.props.hashCode();
        }

        public String toString() {
            return this.props.toString();
        }
    }

    private static class NodeRep
    implements Serializable {
        private final PropertiesRep properties;
        private final Map<Long, PropertiesRep> outRelationships = new HashMap<Long, PropertiesRep>();
        private final long highestRelationshipId;
        private final long id;
        private final Map<String, Map<String, Serializable>> index;

        NodeRep(GraphDatabaseService db, Node node, boolean includeIndexes) {
            this.id = node.getId();
            this.properties = new PropertiesRep((PropertyContainer)node, node.getId());
            long highestRel = 0L;
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                this.outRelationships.put(rel.getId(), new PropertiesRep((PropertyContainer)rel, rel.getId()));
                highestRel = Math.max(highestRel, rel.getId());
            }
            this.highestRelationshipId = highestRel;
            this.index = includeIndexes ? this.checkIndex(db) : null;
        }

        private Map<String, Map<String, Serializable>> checkIndex(GraphDatabaseService db) {
            HashMap<String, Map<String, Serializable>> result = new HashMap<String, Map<String, Serializable>>();
            for (String indexName : db.index().nodeIndexNames()) {
                HashMap thisIndex = new HashMap();
                Index tempIndex = db.index().forNodes(indexName);
                block1: for (Map.Entry property : this.properties.props.entrySet()) {
                    IndexHits content = tempIndex.get((String)property.getKey(), property.getValue());
                    if (!content.hasNext()) continue;
                    for (Node hit : content) {
                        if (hit.getId() != this.id) continue;
                        thisIndex.put(property.getKey(), property.getValue());
                        continue block1;
                    }
                }
                result.put(indexName, thisIndex);
            }
            return result;
        }

        private void compareIndex(NodeRep other, DiffReport diff) {
            if (other.index == this.index) {
                return;
            }
            HashSet<String> allIndexes = new HashSet<String>();
            allIndexes.addAll(this.index.keySet());
            allIndexes.addAll(other.index.keySet());
            for (String indexName : allIndexes) {
                if (!this.index.containsKey(indexName)) {
                    diff.add(this + " isn't indexed in " + indexName + " for mine");
                    continue;
                }
                if (!other.index.containsKey(indexName)) {
                    diff.add(this + " isn't indexed in " + indexName + " for other");
                    continue;
                }
                Map<String, Serializable> thisIndex = this.index.get(indexName);
                Map<String, Serializable> otherIndex = other.index.get(indexName);
                if (thisIndex.size() != otherIndex.size()) {
                    diff.add("other index had a different mapping count than me for node " + this + " mine:" + thisIndex + ", other:" + otherIndex);
                    continue;
                }
                for (Map.Entry<String, Serializable> indexEntry : thisIndex.entrySet()) {
                    if (indexEntry.getValue().equals(otherIndex.get(indexEntry.getKey()))) continue;
                    diff.add("other index had a different value indexed for " + indexEntry.getKey() + "=" + indexEntry.getValue() + ", namely " + otherIndex.get(indexEntry.getKey()) + " for " + this);
                }
            }
        }

        protected void compareWith(NodeRep other, DiffReport diff) {
            if (other.id != this.id) {
                diff.add("Id differs mine:" + this.id + ", other:" + other.id);
            }
            this.properties.compareWith(other.properties, diff);
            if (this.index != null && other.index != null) {
                this.compareIndex(other, diff);
            }
            this.compareRelationships(other, diff);
        }

        private void compareRelationships(NodeRep other, DiffReport diff) {
            for (PropertiesRep rel : this.outRelationships.values()) {
                PropertiesRep otherRel = other.outRelationships.get(rel.entityId);
                if (otherRel == null) {
                    diff.add("I have relationship " + rel.entityId + " which other don't");
                    continue;
                }
                rel.compareWith(otherRel, diff);
            }
            for (Long id : other.outRelationships.keySet()) {
                if (this.outRelationships.containsKey(id)) continue;
                diff.add("Other has relationship " + id + " which I don't");
            }
        }

        public int hashCode() {
            int result = 7;
            result += this.properties.hashCode() * 7;
            result += this.outRelationships.hashCode() * 13;
            result = (int)((long)result + this.id * 17L);
            if (this.index != null) {
                result += this.index.hashCode() * 19;
            }
            return result;
        }

        public String toString() {
            return "<id: " + this.id + " props: " + this.properties + ", rels: " + this.outRelationships + ">";
        }
    }
}

