/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.test.AlgebraicFunction;

public class DatabaseFunctions {
    public static AlgebraicFunction<GraphDatabaseService, Node> createNode() {
        return new AlgebraicFunction<GraphDatabaseService, Node>(){

            @Override
            public Node apply(GraphDatabaseService graphDb) {
                return graphDb.createNode();
            }
        };
    }

    public static AlgebraicFunction<Node, Node> addLabel(final Label label) {
        return new AlgebraicFunction<Node, Node>(){

            @Override
            public Node apply(Node node) {
                node.addLabel(label);
                return node;
            }
        };
    }

    public static AlgebraicFunction<Node, Node> setProperty(final String propertyKey, final Object value) {
        return new AlgebraicFunction<Node, Node>(){

            @Override
            public Node apply(Node node) {
                node.setProperty(propertyKey, value);
                return node;
            }
        };
    }

    public static AlgebraicFunction<GraphDatabaseService, Void> index(final Label label, final String propertyKey) {
        return new AlgebraicFunction<GraphDatabaseService, Void>(){

            @Override
            public Void apply(GraphDatabaseService graphDb) {
                graphDb.schema().indexFor(label).on(propertyKey).create();
                return null;
            }
        };
    }

    public static AlgebraicFunction<GraphDatabaseService, Void> uniquenessConstraint(final Label label, final String propertyKey) {
        return new AlgebraicFunction<GraphDatabaseService, Void>(){

            @Override
            public Void apply(GraphDatabaseService graphDb) {
                graphDb.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create();
                return null;
            }
        };
    }

    public static AlgebraicFunction<GraphDatabaseService, Void> awaitIndexesOnline(final long timeout, final TimeUnit unit) {
        return new AlgebraicFunction<GraphDatabaseService, Void>(){

            @Override
            public Void apply(GraphDatabaseService graphDb) {
                graphDb.schema().awaitIndexesOnline(timeout, unit);
                return null;
            }
        };
    }

    private DatabaseFunctions() {
    }
}

