/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.PrintWriter;
import java.util.Objects;
import org.neo4j.function.Consumer;
import org.neo4j.function.Supplier;
import org.neo4j.logging.Logger;

public abstract class AbstractPrintWriterLogger
implements Logger {
    private final Supplier<PrintWriter> writerSupplier;
    private final Object lock;
    private final boolean autoFlush;

    protected AbstractPrintWriterLogger(Supplier<PrintWriter> writerSupplier, Object lock, boolean autoFlush) {
        this.writerSupplier = writerSupplier;
        this.lock = lock;
        this.autoFlush = autoFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String message) {
        PrintWriter writer;
        Objects.requireNonNull(message, "message must not be null");
        Object object = this.lock;
        synchronized (object) {
            writer = this.writerSupplier.get();
            this.writeLog(writer, message);
        }
        this.maybeFlush(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String message, Throwable throwable) {
        PrintWriter writer;
        Objects.requireNonNull(message, "message must not be null");
        if (throwable == null) {
            this.log(message);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            writer = this.writerSupplier.get();
            this.writeLog(writer, message, throwable);
        }
        this.maybeFlush(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String format, Object ... arguments) {
        PrintWriter writer;
        Objects.requireNonNull(format, "format must not be null");
        if (arguments == null || arguments.length == 0) {
            this.log(format);
            return;
        }
        String message = String.format(format, arguments);
        Object object = this.lock;
        synchronized (object) {
            writer = this.writerSupplier.get();
            this.writeLog(writer, message);
        }
        this.maybeFlush(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulk(Consumer<Logger> consumer) {
        PrintWriter writer;
        Objects.requireNonNull(consumer, "consumer must not be null");
        Object object = this.lock;
        synchronized (object) {
            writer = this.writerSupplier.get();
            consumer.accept(this.getBulkLogger(writer, this.lock));
        }
        this.maybeFlush(writer);
    }

    protected abstract void writeLog(PrintWriter var1, String var2);

    protected abstract void writeLog(PrintWriter var1, String var2, Throwable var3);

    protected abstract Logger getBulkLogger(PrintWriter var1, Object var2);

    private void maybeFlush(PrintWriter writer) {
        if (this.autoFlush) {
            writer.flush();
        }
    }
}

