/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.function.Consumer;
import org.neo4j.function.Factory;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.impl.util.collection.ConcurrentAccessException;
import org.neo4j.kernel.impl.util.collection.NoSuchEntryException;
import org.neo4j.kernel.impl.util.collection.TimedRepository;
import org.neo4j.test.ArtificialClock;

public class TimedRepositoryTest {
    private final AtomicLong valueGenerator = new AtomicLong();
    private final List<Long> reapedValues = new ArrayList<Long>();
    private final Factory<Long> provider = new Factory<Long>(){

        @Override
        public Long newInstance() {
            return TimedRepositoryTest.this.valueGenerator.getAndIncrement();
        }
    };
    private final Consumer<Long> consumer = new Consumer<Long>(){

        @Override
        public void accept(Long value) {
            TimedRepositoryTest.this.reapedValues.add(value);
        }
    };
    private final long timeout = 100L;
    private final ArtificialClock clock = new ArtificialClock();
    private final TimedRepository<Long, Long> repo = new TimedRepository(this.provider, this.consumer, 100L, (Clock)this.clock);

    @Test
    public void shouldManageLifecycleWithNoTimeouts() throws Exception {
        this.repo.begin((Object)1L);
        long acquired = (Long)this.repo.acquire((Object)1L);
        this.repo.release((Object)1L);
        this.repo.end((Object)1L);
        MatcherAssert.assertThat((Object)acquired, (Matcher)CoreMatchers.equalTo((Object)0L));
        MatcherAssert.assertThat(this.reapedValues, (Matcher)CoreMatchers.equalTo(Arrays.asList(0L)));
    }

    @Test
    public void shouldNotAllowOthersAccessWhenAcquired() throws Exception {
        this.repo.begin((Object)1L);
        this.repo.acquire((Object)1L);
        try {
            this.repo.acquire((Object)1L);
            Assert.fail((String)"Should not have been allowed access.");
        }
        catch (ConcurrentAccessException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Cannot access '1', because another client is currently using it."));
        }
        this.repo.release((Object)1L);
        MatcherAssert.assertThat((Object)this.repo.acquire((Object)1L), (Matcher)CoreMatchers.equalTo((Object)0L));
    }

    @Test
    public void shouldNotAllowAccessAfterEnd() throws Exception {
        this.repo.begin((Object)1L);
        this.repo.end((Object)1L);
        try {
            this.repo.acquire((Object)1L);
            Assert.fail((String)"Should not have been able to acquire.");
        }
        catch (NoSuchEntryException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Cannot access '1', no such entry exists."));
        }
    }

    @Test
    public void shouldSilentlyAllowMultipleEndings() throws Exception {
        this.repo.begin((Object)1L);
        this.repo.end((Object)1L);
        this.repo.end((Object)1L);
    }

    @Test
    public void shouldNotEndImmediatelyIfEntryIsUsed() throws Exception {
        this.repo.begin((Object)1L);
        this.repo.acquire((Object)1L);
        this.repo.end((Object)1L);
        Assert.assertTrue((boolean)this.reapedValues.isEmpty());
        this.repo.release((Object)1L);
        MatcherAssert.assertThat(this.reapedValues, (Matcher)CoreMatchers.equalTo(Arrays.asList(0L)));
    }

    @Test
    public void shouldNotAllowBeginningWithDuplicateKey() throws Exception {
        this.repo.begin((Object)1L);
        try {
            this.repo.begin((Object)1L);
            Assert.fail((String)"Should not have been able to begin.");
        }
        catch (ConcurrentAccessException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot begin '1', because Entry"));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)" with that key already exists."));
        }
    }

    @Test
    public void shouldTimeOutUnusedEntries() throws Exception {
        this.repo.begin((Object)1L);
        this.repo.acquire((Object)1L);
        this.repo.release((Object)1L);
        this.repo.run();
        MatcherAssert.assertThat((Object)this.repo.acquire((Object)1L), (Matcher)CoreMatchers.equalTo((Object)0L));
        this.repo.release((Object)1L);
        this.clock.progress(101L, TimeUnit.MILLISECONDS);
        this.repo.run();
        MatcherAssert.assertThat(this.reapedValues, (Matcher)CoreMatchers.equalTo(Arrays.asList(0L)));
        try {
            this.repo.acquire((Object)1L);
            Assert.fail((String)"Should not have been possible to acquire.");
        }
        catch (NoSuchEntryException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Cannot access '1', no such entry exists."));
        }
    }

    @Test
    public void usingDuplicateKeysShouldDisposeOfPreemptiveAllocatedValue() throws Exception {
        this.repo.begin((Object)1L);
        try {
            this.repo.begin((Object)1L);
            Assert.fail((String)"Should not have been able to begin.");
        }
        catch (ConcurrentAccessException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot begin '1', because Entry"));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)" with that key already exists."));
        }
        MatcherAssert.assertThat(this.reapedValues, (Matcher)CoreMatchers.equalTo(Arrays.asList(1L)));
    }

    @Test
    public void shouldAllowBeginWithSameKeyAfterSessionRelease() throws Exception {
        this.repo.begin((Object)1L);
        this.repo.acquire((Object)1L);
        this.repo.release((Object)1L);
        this.repo.end((Object)1L);
        this.repo.begin((Object)1L);
        MatcherAssert.assertThat(this.reapedValues, (Matcher)CoreMatchers.equalTo(Arrays.asList(0L)));
    }
}

