/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.function.Factory;

public class AutoCreatingHashMap<K, V>
extends HashMap<K, V> {
    private final Factory<V> valueCreator;

    public AutoCreatingHashMap(Factory<V> valueCreator) {
        this.valueCreator = valueCreator;
    }

    @Override
    public V get(Object key) {
        if (!super.containsKey(key)) {
            this.put(key, this.valueCreator.newInstance());
        }
        return super.get(key);
    }

    public static <V> Factory<V> values(final Class<V> valueType) {
        return new Factory<V>(){

            @Override
            public V newInstance() {
                try {
                    return valueType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static <K, V> Factory<Map<K, V>> nested(Class<K> keyClass, final Factory<V> nested) {
        return new Factory<Map<K, V>>(){

            @Override
            public Map<K, V> newInstance() {
                return new AutoCreatingHashMap(nested);
            }
        };
    }

    public static <V> Factory<V> dontCreate() {
        return new Factory<V>(){

            @Override
            public V newInstance() {
                return null;
            }
        };
    }

    public static <V> Factory<Set<V>> valuesOfTypeHashSet() {
        return new Factory<Set<V>>(){

            @Override
            public Set<V> newInstance() {
                return new HashSet();
            }
        };
    }
}

