/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.util.Bits;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class NodeLabelsFieldTest {
    private NeoStores neoStores;
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private NodeStore nodeStore;

    @Test
    public void shouldInlineOneLabel() throws Exception {
        long labelId = 10L;
        NodeRecord node = this.nodeRecordWithInlinedLabels(new long[0]);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        nodeLabels.add(labelId, null, null);
        Assert.assertEquals((long)this.inlinedLabelsLongRepresentation(labelId), (long)node.getLabelField());
    }

    @Test
    public void shouldInlineOneLabelWithHighId() throws Exception {
        long labelId = 10000L;
        NodeRecord node = this.nodeRecordWithInlinedLabels(new long[0]);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        nodeLabels.add(labelId, null, null);
        Assert.assertEquals((long)this.inlinedLabelsLongRepresentation(labelId), (long)node.getLabelField());
    }

    @Test
    public void shouldInlineTwoSmallLabels() throws Exception {
        long labelId1 = 10L;
        long labelId2 = 30L;
        NodeRecord node = this.nodeRecordWithInlinedLabels(labelId1);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        nodeLabels.add(labelId2, null, null);
        Assert.assertEquals((long)this.inlinedLabelsLongRepresentation(labelId1, labelId2), (long)node.getLabelField());
    }

    @Test
    public void shouldInlineThreeSmallLabels() throws Exception {
        long labelId1 = 10L;
        long labelId2 = 30L;
        long labelId3 = 4095L;
        NodeRecord node = this.nodeRecordWithInlinedLabels(labelId1, labelId2);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        nodeLabels.add(labelId3, null, null);
        Assert.assertEquals((long)this.inlinedLabelsLongRepresentation(labelId1, labelId2, labelId3), (long)node.getLabelField());
    }

    @Test
    public void shouldInlineFourSmallLabels() throws Exception {
        long labelId1 = 10L;
        long labelId2 = 30L;
        long labelId3 = 45L;
        long labelId4 = 60L;
        NodeRecord node = this.nodeRecordWithInlinedLabels(labelId1, labelId2, labelId3);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        nodeLabels.add(labelId4, null, null);
        Assert.assertEquals((long)this.inlinedLabelsLongRepresentation(labelId1, labelId2, labelId3, labelId4), (long)node.getLabelField());
    }

    @Test
    public void shouldInlineFiveSmallLabels() throws Exception {
        long labelId1 = 10L;
        long labelId2 = 30L;
        long labelId3 = 45L;
        long labelId4 = 60L;
        long labelId5 = 61L;
        NodeRecord node = this.nodeRecordWithInlinedLabels(labelId1, labelId2, labelId3, labelId4);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        nodeLabels.add(labelId5, null, null);
        Assert.assertEquals((long)this.inlinedLabelsLongRepresentation(labelId1, labelId2, labelId3, labelId4, labelId5), (long)node.getLabelField());
    }

    @Test
    public void shouldSpillOverToDynamicRecordIfExceedsInlinedSpace() throws Exception {
        long labelId1 = 10L;
        long labelId2 = 30L;
        long labelId3 = 4096L;
        NodeRecord node = this.nodeRecordWithInlinedLabels(labelId1, labelId2);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        Collection changedDynamicRecords = nodeLabels.add(labelId3, this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore());
        Assert.assertEquals((long)1L, (long)IteratorUtil.count((Iterable)changedDynamicRecords));
        Assert.assertEquals((long)this.dynamicLabelsLongRepresentation(changedDynamicRecords), (long)node.getLabelField());
        Assert.assertTrue((boolean)Arrays.equals(new long[]{labelId1, labelId2, labelId3}, this.nodeStore.getDynamicLabelsArray((Iterable)changedDynamicRecords)));
    }

    @Test
    public void oneDynamicRecordShouldExtendIntoAnAdditionalIfTooManyLabels() throws Exception {
        NodeRecord node = this.nodeRecordWithDynamicLabels(this.nodeStore, this.oneByteLongs(56));
        Collection initialRecords = node.getDynamicLabelRecords();
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        Set changedDynamicRecords = IteratorUtil.asSet((Iterable)nodeLabels.add(1L, this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore()));
        Assert.assertTrue((boolean)changedDynamicRecords.containsAll(initialRecords));
        Assert.assertEquals((long)(initialRecords.size() + 1), (long)changedDynamicRecords.size());
    }

    @Test
    public void oneDynamicRecordShouldStoreItsOwner() throws Exception {
        Long nodeId = 24L;
        NodeRecord node = this.nodeRecordWithDynamicLabels(nodeId, this.nodeStore, this.oneByteLongs(56));
        Collection initialRecords = node.getDynamicLabelRecords();
        Pair pair = this.nodeStore.getDynamicLabelsArrayAndOwner((Iterable)initialRecords);
        Assert.assertEquals((Object)nodeId, (Object)pair.first());
    }

    @Test
    public void twoDynamicRecordsShouldShrinkToOneWhenRemoving() throws Exception {
        NodeRecord node = this.nodeRecordWithDynamicLabels(this.nodeStore, this.oneByteLongs(57));
        Collection initialRecords = node.getDynamicLabelRecords();
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        List changedDynamicRecords = (List)IteratorUtil.addToCollection((Iterable)nodeLabels.remove(255L, this.nodeStore), new ArrayList());
        Assert.assertEquals((Object)initialRecords, (Object)changedDynamicRecords);
        Assert.assertTrue((boolean)((DynamicRecord)changedDynamicRecords.get(0)).inUse());
        Assert.assertFalse((boolean)((DynamicRecord)changedDynamicRecords.get(1)).inUse());
    }

    @Test
    public void twoDynamicRecordsShouldShrinkToOneWhenRemovingWithoutChangingItsOwner() throws Exception {
        Long nodeId = 42L;
        NodeRecord node = this.nodeRecordWithDynamicLabels(nodeId, this.nodeStore, this.oneByteLongs(57));
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        List changedDynamicRecords = (List)IteratorUtil.addToCollection((Iterable)nodeLabels.remove(255L, this.nodeStore), new ArrayList());
        Pair changedPair = this.nodeStore.getDynamicLabelsArrayAndOwner((Iterable)changedDynamicRecords);
        Assert.assertEquals((Object)nodeId, (Object)changedPair.first());
    }

    @Test
    public void oneDynamicRecordShouldShrinkIntoInlinedWhenRemoving() throws Exception {
        NodeRecord node = this.nodeRecordWithDynamicLabels(this.nodeStore, this.oneByteLongs(5));
        Collection initialRecords = node.getDynamicLabelRecords();
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        Collection changedDynamicRecords = IteratorUtil.asCollection((Iterable)nodeLabels.remove(255L, this.nodeStore));
        Assert.assertEquals((Object)initialRecords, (Object)changedDynamicRecords);
        Assert.assertFalse((boolean)((DynamicRecord)IteratorUtil.single((Iterable)changedDynamicRecords)).inUse());
        Assert.assertEquals((long)this.inlinedLabelsLongRepresentation(251L, 252L, 253L, 254L), (long)node.getLabelField());
    }

    @Test
    public void shouldReadIdOfDynamicRecordFromDynamicLabelsField() throws Exception {
        NodeRecord node = this.nodeRecordWithDynamicLabels(this.nodeStore, this.oneByteLongs(5));
        DynamicRecord dynamicRecord = (DynamicRecord)node.getDynamicLabelRecords().iterator().next();
        long dynRecordId = NodeLabelsField.firstDynamicLabelRecordId((long)node.getLabelField());
        Assert.assertEquals((long)dynamicRecord.getLongId(), (long)dynRecordId);
    }

    @Test
    public void shouldReadNullDynamicRecordFromInlineLabelsField() throws Exception {
        NodeRecord node = this.nodeRecordWithInlinedLabels(23L);
        boolean isDynamicReference = NodeLabelsField.fieldPointsToDynamicRecordOfLabels((long)node.getLabelField());
        Assert.assertFalse((boolean)isDynamicReference);
    }

    @Test
    public void maximumOfSevenInlinedLabels() throws Exception {
        long[] labels = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L};
        NodeRecord node = this.nodeRecordWithInlinedLabels(labels);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        Collection changedDynamicRecords = nodeLabels.add(23L, this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore());
        Assert.assertEquals((long)this.dynamicLabelsLongRepresentation(changedDynamicRecords), (long)node.getLabelField());
        Assert.assertEquals((long)1L, (long)IteratorUtil.count((Iterable)changedDynamicRecords));
    }

    @Test
    public void addingAnAlreadyAddedLabelWhenLabelsAreInlinedShouldFail() throws Exception {
        int labelId = 1;
        NodeRecord node = this.nodeRecordWithInlinedLabels(labelId);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        try {
            nodeLabels.add((long)labelId, this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore());
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void addingAnAlreadyAddedLabelWhenLabelsAreInDynamicRecordsShouldFail() throws Exception {
        long[] labels = this.oneByteLongs(20);
        NodeRecord node = this.nodeRecordWithDynamicLabels(this.nodeStore, labels);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        try {
            nodeLabels.add((long)IoPrimitiveUtils.safeCastLongToInt((long)labels[0]), this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore());
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void removingNonExistentInlinedLabelShouldFail() throws Exception {
        int labelId1 = 1;
        int labelId2 = 2;
        NodeRecord node = this.nodeRecordWithInlinedLabels(labelId1);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        try {
            nodeLabels.remove((long)labelId2, this.nodeStore);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void removingNonExistentLabelInDynamicRecordsShouldFail() throws Exception {
        long[] labels = this.oneByteLongs(20);
        NodeRecord node = this.nodeRecordWithDynamicLabels(this.nodeStore, labels);
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        try {
            nodeLabels.remove(123456L, this.nodeStore);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReallocateSomeOfPreviousDynamicRecords() throws Exception {
        NodeRecord node = this.nodeRecordWithDynamicLabels(this.nodeStore, this.oneByteLongs(5));
        Set initialRecords = IteratorUtil.asUniqueSet((Iterable)node.getDynamicLabelRecords());
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        Set reallocatedRecords = IteratorUtil.asUniqueSet((Iterable)nodeLabels.put(this.fourByteLongs(100), this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore()));
        Assert.assertTrue((boolean)reallocatedRecords.containsAll(initialRecords));
        Assert.assertTrue((reallocatedRecords.size() > initialRecords.size() ? 1 : 0) != 0);
    }

    @Test
    public void shouldReallocateAllOfPreviousDynamicRecordsAndThenSome() throws Exception {
        NodeRecord node = this.nodeRecordWithDynamicLabels(this.nodeStore, this.fourByteLongs(100));
        Set initialRecords = IteratorUtil.asSet((Iterable)IteratorUtil.cloned((Iterable)node.getDynamicLabelRecords(), DynamicRecord.class));
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)node);
        Set reallocatedRecords = IteratorUtil.asUniqueSet((Iterable)nodeLabels.put(this.fourByteLongs(5), this.nodeStore, (DynamicRecordAllocator)this.nodeStore.getDynamicLabelStore()));
        Assert.assertTrue((String)("initial:" + initialRecords + ", reallocated:" + reallocatedRecords), (boolean)initialRecords.containsAll(this.used(reallocatedRecords)));
        Assert.assertTrue((this.used(reallocatedRecords).size() < initialRecords.size() ? 1 : 0) != 0);
    }

    private long dynamicLabelsLongRepresentation(Iterable<DynamicRecord> records) {
        return 0x8000000000L | ((DynamicRecord)IteratorUtil.first(records)).getId();
    }

    private long inlinedLabelsLongRepresentation(long ... labelIds) {
        long header = (long)labelIds.length << 36;
        byte bitsPerLabel = (byte)(36 / labelIds.length);
        Bits bits = Bits.bits((int)5);
        for (long labelId : labelIds) {
            bits.put(labelId, (int)bitsPerLabel);
        }
        return header | bits.getLongs()[0];
    }

    @Before
    public void startUp() {
        File storeDir = new File("dir");
        this.fs.get().mkdirs(storeDir);
        StoreFactory storeFactory = new StoreFactory(storeDir, new Config(), (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs.get()), pageCacheRule.getPageCache(this.fs.get()), (FileSystemAbstraction)this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        this.neoStores = storeFactory.openAllNeoStores(true);
        this.nodeStore = this.neoStores.getNodeStore();
    }

    @After
    public void cleanUp() {
        this.neoStores.close();
    }

    private NodeRecord nodeRecordWithInlinedLabels(long ... labels) {
        NodeRecord node = new NodeRecord(0L, false, 0L, 0L);
        if (labels.length > 0) {
            node.setLabelField(this.inlinedLabelsLongRepresentation(labels), Collections.emptyList());
        }
        return node;
    }

    private NodeRecord nodeRecordWithDynamicLabels(NodeStore nodeStore, long ... labels) {
        return this.nodeRecordWithDynamicLabels(0L, nodeStore, labels);
    }

    private NodeRecord nodeRecordWithDynamicLabels(long nodeId, NodeStore nodeStore, long ... labels) {
        NodeRecord node = new NodeRecord(nodeId, false, 0L, 0L);
        Collection<DynamicRecord> initialRecords = this.allocateAndApply(nodeStore, node.getId(), labels);
        node.setLabelField(this.dynamicLabelsLongRepresentation(initialRecords), initialRecords);
        return node;
    }

    private Collection<DynamicRecord> allocateAndApply(NodeStore nodeStore, long nodeId, long[] longs) {
        Collection records = nodeStore.allocateRecordsForDynamicLabels(nodeId, longs, (Iterator)IteratorUtil.emptyIterator());
        nodeStore.updateDynamicLabelRecords((Iterable)records);
        return records;
    }

    private long[] oneByteLongs(int numberOfLongs) {
        long[] result = new long[numberOfLongs];
        for (int i = 0; i < numberOfLongs; ++i) {
            result[i] = 255 - i;
        }
        Arrays.sort(result);
        return result;
    }

    private long[] fourByteLongs(int numberOfLongs) {
        long[] result = new long[numberOfLongs];
        for (int i = 0; i < numberOfLongs; ++i) {
            result[i] = Integer.MAX_VALUE - i;
        }
        Arrays.sort(result);
        return result;
    }

    private Set<DynamicRecord> used(Set<DynamicRecord> reallocatedRecords) {
        HashSet<DynamicRecord> used = new HashSet<DynamicRecord>();
        for (DynamicRecord record : reallocatedRecords) {
            if (!record.inUse()) continue;
            used.add(record);
        }
        return used;
    }
}

