/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CommandApplierFacade;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.Abstract64BitRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandHandler;
import org.neo4j.kernel.impl.transaction.command.NeoStoreTransactionApplier;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class ApplyRecoveredTransactionsTest {
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private NeoStores neoStores;

    @Test
    public void shouldSetCorrectHighIdWhenApplyingExternalTransactions() throws Exception {
        long nodeId = this.neoStores.getNodeStore().nextId();
        long relationshipId = this.neoStores.getRelationshipStore().nextId();
        int type = 1;
        this.applyExternalTransaction(1L, this.nodeCommand(this.node(nodeId), this.inUse(this.created(this.node(nodeId)))), this.relationshipCommand(this.inUse(this.created(this.with(this.relationship(relationshipId), nodeId, nodeId, type)))));
        this.applyExternalTransaction(2L, this.nodeCommand(this.inUse(this.created(this.node(nodeId))), this.node(nodeId)), this.relationshipCommand(this.relationship(relationshipId)));
        Assert.assertEquals((long)(nodeId + 1L), (long)this.neoStores.getNodeStore().getHighId());
        Assert.assertEquals((long)(relationshipId + 1L), (long)this.neoStores.getRelationshipStore().getHighId());
    }

    private RelationshipRecord with(RelationshipRecord relationship, long startNode, long endNode, int type) {
        relationship.setFirstNode(startNode);
        relationship.setSecondNode(endNode);
        relationship.setType(type);
        return relationship;
    }

    private Command relationshipCommand(RelationshipRecord relationship) {
        Command.RelationshipCommand command = new Command.RelationshipCommand();
        command.init(relationship);
        return command;
    }

    private RelationshipRecord relationship(long relationshipId) {
        return new RelationshipRecord(relationshipId);
    }

    private void applyExternalTransaction(long transactionId, Command ... commands) throws IOException {
        NeoStoreTransactionApplier applier = new NeoStoreTransactionApplier(this.neoStores, (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class), (LockService)Mockito.mock(LockService.class), new LockGroup(), transactionId);
        CommandApplierFacade applierFacade = new CommandApplierFacade(new CommandHandler[]{applier, (CommandHandler)Mockito.mock(CommandHandler.class), (CommandHandler)Mockito.mock(CommandHandler.class), (CommandHandler)Mockito.mock(CommandHandler.class)});
        new PhysicalTransactionRepresentation(Arrays.asList(commands)).accept((Visitor)applierFacade);
    }

    @Before
    public void before() {
        EphemeralFileSystemAbstraction fs = this.fsr.get();
        File storeDir = new File("dir");
        StoreFactory storeFactory = new StoreFactory(storeDir, new Config(), (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)fs), this.pageCacheRule.getPageCache(fs), (FileSystemAbstraction)fs, (LogProvider)NullLogProvider.getInstance());
        this.neoStores = storeFactory.openAllNeoStores(true);
    }

    @After
    public void after() {
        this.neoStores.close();
    }

    private Command nodeCommand(NodeRecord before, NodeRecord after) {
        Command.NodeCommand command = new Command.NodeCommand();
        command.init(before, after);
        return command;
    }

    private <RECORD extends Abstract64BitRecord> RECORD inUse(RECORD record) {
        record.setInUse(true);
        return record;
    }

    private <RECORD extends Abstract64BitRecord> RECORD created(RECORD record) {
        record.setCreated();
        return record;
    }

    private NodeRecord node(long id) {
        return new NodeRecord(id);
    }
}

