/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.transaction.log.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.TransactionCountThreshold;

public class TransactionCountThresholdTest {
    private LogFileInformation info = (LogFileInformation)Mockito.mock(LogFileInformation.class);
    private File file = (File)Mockito.mock(File.class);

    @Test
    public void shouldReportThresholdReachedWhenThresholdIsReached() throws Exception {
        long version = 10L;
        Mockito.when((Object)this.info.getFirstCommittedTxId(version + 1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getLastCommittedTxId()).thenReturn((Object)2L);
        TransactionCountThreshold threshold = new TransactionCountThreshold(1L);
        boolean reached = threshold.reached(this.file, version, this.info);
        Assert.assertTrue((boolean)reached);
    }

    @Test
    public void shouldReportThresholdNotReachedWhenThresholdIsNotReached() throws Exception {
        long version = 10L;
        Mockito.when((Object)this.info.getFirstCommittedTxId(version + 1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getLastCommittedTxId()).thenReturn((Object)2L);
        TransactionCountThreshold threshold = new TransactionCountThreshold(2L);
        boolean reached = threshold.reached(this.file, version, this.info);
        Assert.assertFalse((boolean)reached);
    }

    @Test
    public void shouldReturnTrueWhenLogFormatVersionIsOlderThanTheRequiredOne() throws Exception {
        long version = 10L;
        Mockito.when((Object)this.info.getFirstCommittedTxId(version + 1L)).thenThrow(new Throwable[]{new IllegalLogFormatException(9L, 8L)});
        TransactionCountThreshold threshold = new TransactionCountThreshold(2L);
        boolean reached = threshold.reached(this.file, version, this.info);
        Assert.assertTrue((boolean)reached);
    }

    @Test
    public void shouldThrowExceptionWhenLogFormatVersionIsNewerThanTheRequiredOne() throws Exception {
        long version = 10L;
        Mockito.when((Object)this.info.getFirstCommittedTxId(version + 1L)).thenThrow(new Throwable[]{new IllegalLogFormatException(9L, 11L)});
        TransactionCountThreshold threshold = new TransactionCountThreshold(2L);
        try {
            threshold.reached(this.file, version, this.info);
            Assert.fail((String)"should have thrown IllegalLogFormatException");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalLogFormatException));
            Assert.assertTrue((boolean)((IllegalLogFormatException)e.getCause()).wasNewerLogVersion());
        }
    }

    @Test
    public void shouldWorkWhenCalledMultipleTimesKeeping2Files() throws Exception {
        Mockito.when((Object)this.info.getFirstCommittedTxId(1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(2L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(3L)).thenReturn((Object)15L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(4L)).thenReturn((Object)18L);
        Mockito.when((Object)this.info.getLastCommittedTxId()).thenReturn((Object)18L);
        TransactionCountThreshold threshold = new TransactionCountThreshold(8L);
        Assert.assertTrue((boolean)threshold.reached(this.file, 1L, this.info));
        Assert.assertFalse((boolean)threshold.reached(this.file, 2L, this.info));
        Assert.assertFalse((boolean)threshold.reached(this.file, 3L, this.info));
    }

    @Test
    public void shouldWorkWhenCalledMultipleTimesKeeping3Files() throws Exception {
        Mockito.when((Object)this.info.getFirstCommittedTxId(1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(2L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(3L)).thenReturn((Object)15L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(4L)).thenReturn((Object)18L);
        Mockito.when((Object)this.info.getLastCommittedTxId()).thenReturn((Object)18L);
        TransactionCountThreshold threshold = new TransactionCountThreshold(15L);
        Assert.assertFalse((boolean)threshold.reached(this.file, 1L, this.info));
        Assert.assertFalse((boolean)threshold.reached(this.file, 2L, this.info));
        Assert.assertFalse((boolean)threshold.reached(this.file, 3L, this.info));
    }

    @Test
    public void shouldWorkWhenCalledMultipleTimesKeeping1FileOnBoundary() throws Exception {
        Mockito.when((Object)this.info.getFirstCommittedTxId(1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(2L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(3L)).thenReturn((Object)15L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(4L)).thenReturn((Object)18L);
        Mockito.when((Object)this.info.getLastCommittedTxId()).thenReturn((Object)18L);
        TransactionCountThreshold threshold = new TransactionCountThreshold(3L);
        Assert.assertTrue((boolean)threshold.reached(this.file, 1L, this.info));
        Assert.assertTrue((boolean)threshold.reached(this.file, 2L, this.info));
        Assert.assertFalse((boolean)threshold.reached(this.file, 3L, this.info));
    }

    @Test
    public void shouldSkipEmptyLogsBetweenLogsThatWillBeKept() throws Exception {
        Mockito.when((Object)this.info.getFirstCommittedTxId(1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(2L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(3L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(4L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(5L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(6L)).thenReturn((Object)13L);
        Mockito.when((Object)this.info.getLastCommittedTxId()).thenReturn((Object)13L);
        TransactionCountThreshold threshold = new TransactionCountThreshold(9L);
        Assert.assertFalse((boolean)threshold.reached(this.file, 5L, this.info));
        Assert.assertFalse((boolean)threshold.reached(this.file, 4L, this.info));
        Assert.assertFalse((boolean)threshold.reached(this.file, 3L, this.info));
        Assert.assertFalse((boolean)threshold.reached(this.file, 2L, this.info));
        Assert.assertTrue((boolean)threshold.reached(this.file, 1L, this.info));
    }

    @Test
    public void shouldDeleteNonEmptyLogThatIsAfterASeriesOfEmptyLogs() throws Exception {
        Mockito.when((Object)this.info.getFirstCommittedTxId(1L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(2L)).thenReturn((Object)1L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(3L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(4L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(5L)).thenReturn((Object)5L);
        Mockito.when((Object)this.info.getFirstCommittedTxId(6L)).thenReturn((Object)13L);
        Mockito.when((Object)this.info.getLastCommittedTxId()).thenReturn((Object)13L);
        TransactionCountThreshold threshold = new TransactionCountThreshold(8L);
        Assert.assertFalse((boolean)threshold.reached(this.file, 5L, this.info));
        Assert.assertTrue((boolean)threshold.reached(this.file, 4L, this.info));
        Assert.assertTrue((boolean)threshold.reached(this.file, 3L, this.info));
        Assert.assertTrue((boolean)threshold.reached(this.file, 2L, this.info));
        Assert.assertTrue((boolean)threshold.reached(this.file, 1L, this.info));
    }
}

