/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.test.DoubleLatch;

public class SynchronizedArrayIdOrderingQueueStressTest {
    @Test
    public void shouldWithstandHighStressAndStillKeepOrder() throws Exception {
        VerifyingIdOrderingQueue queue = new VerifyingIdOrderingQueue((IdOrderingQueue)new SynchronizedArrayIdOrderingQueue(5));
        Committer[] committers = new Committer[20];
        CountDownLatch readySignal = new CountDownLatch(committers.length);
        AtomicLong endTime = new AtomicLong();
        CountDownLatch startSignal = new CountDownLatch(1);
        PrimitiveLongIterator idSource = this.neverEndingIdStream();
        for (int i = 0; i < committers.length; ++i) {
            committers[i] = new Committer(queue, idSource, endTime, readySignal, startSignal);
        }
        readySignal.await();
        endTime.set(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(3L));
        startSignal.countDown();
        for (Committer committer : committers) {
            committer.awaitFinish();
        }
        Assert.assertTrue((String)("Would have wanted at least a few ids to be processed, but only saw " + queue.getNumberOfOrderlyRemovedIds()), (queue.getNumberOfOrderlyRemovedIds() > 50 ? 1 : 0) != 0);
    }

    private PrimitiveLongIterator neverEndingIdStream() {
        return new PrimitiveLongIterator(){
            private final Stride stride = new Stride();
            private long next;

            @Override
            public boolean hasNext() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long next() {
                try {
                    long l = this.next;
                    return l;
                }
                finally {
                    this.next += (long)this.stride.next();
                }
            }
        };
    }

    private static class Stride {
        private int stride;
        private final int max = 5;

        private Stride() {
        }

        public int next() {
            return this.stride++ % 5 + 1;
        }
    }

    private static class Committer
    extends Thread {
        private final Random random = new Random();
        private final IdOrderingQueue queue;
        private final AtomicLong endTime;
        private final CountDownLatch startSignal;
        private final PrimitiveLongIterator idSource;
        private final CountDownLatch readySignal;
        private volatile Exception exception;

        public Committer(IdOrderingQueue queue, PrimitiveLongIterator idSource, AtomicLong endTime, CountDownLatch readySignal, CountDownLatch startSignal) {
            this.queue = queue;
            this.idSource = idSource;
            this.endTime = endTime;
            this.readySignal = readySignal;
            this.startSignal = startSignal;
            this.start();
        }

        public void awaitFinish() throws Exception {
            this.join();
            if (this.exception != null) {
                throw this.exception;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.readySignal.countDown();
                DoubleLatch.awaitLatch(this.startSignal);
                while (System.currentTimeMillis() < this.endTime.get()) {
                    long id;
                    IdOrderingQueue idOrderingQueue = this.queue;
                    synchronized (idOrderingQueue) {
                        id = this.idSource.next();
                        this.queue.offer(id);
                    }
                    this.queue.waitFor(id);
                    int max = this.random.nextInt(10000);
                    for (int i = 0; i < max; ++i) {
                        this.queue.isEmpty();
                    }
                    this.queue.removeChecked(id);
                }
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }

    private static class VerifyingIdOrderingQueue
    implements IdOrderingQueue {
        private final IdOrderingQueue delegate;
        private final AtomicInteger removedCount = new AtomicInteger();
        private volatile long previousId = -1L;

        public VerifyingIdOrderingQueue(IdOrderingQueue delegate) {
            this.delegate = delegate;
        }

        public void removeChecked(long expectedValue) {
            if (expectedValue < this.previousId) {
                Assert.assertTrue((String)("Expected to remove head " + expectedValue + ", which should have been greater than previously seen id " + this.previousId), (expectedValue > this.previousId ? 1 : 0) != 0);
            }
            this.previousId = expectedValue;
            this.delegate.removeChecked(expectedValue);
            this.removedCount.incrementAndGet();
        }

        public void offer(long value) {
            this.delegate.offer(value);
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public void waitFor(long value) throws InterruptedException {
            this.delegate.waitFor(value);
        }

        public int getNumberOfOrderlyRemovedIds() {
            return this.removedCount.get();
        }
    }
}

