/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.GraphTransactionRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.OtherThreadExecutor;

public class ManualAcquireLockTest {
    public DatabaseRule db = new ImpermanentDatabaseRule();
    public GraphTransactionRule tx = new GraphTransactionRule(this.db);
    @Rule
    public TestRule chain = RuleChain.outerRule((TestRule)this.db).around((TestRule)this.tx);
    private Worker worker;

    @Before
    public void doBefore() throws Exception {
        this.worker = new Worker();
    }

    @After
    public void doAfter() throws Exception {
        this.worker.close();
    }

    @Test
    public void releaseReleaseManually() throws Exception {
        String key = "name";
        Node node = this.getGraphDb().createNode();
        this.tx.success();
        Transaction current = this.tx.begin();
        Lock nodeLock = current.acquireWriteLock((PropertyContainer)node);
        this.worker.beginTx();
        try {
            this.worker.setProperty(node, key, "ksjd");
            Assert.fail((String)"Shouldn't be able to grab it");
        }
        catch (Exception exception) {
            // empty catch block
        }
        nodeLock.release();
        this.worker.setProperty(node, key, "yo");
        try {
            this.worker.finishTx();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void canOnlyReleaseOnce() throws Exception {
        Node node = this.getGraphDb().createNode();
        this.tx.success();
        Transaction current = this.tx.begin();
        Lock nodeLock = current.acquireWriteLock((PropertyContainer)node);
        nodeLock.release();
        try {
            nodeLock.release();
            Assert.fail((String)"Shouldn't be able to release more than once");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void makeSureNodeStaysLockedEvenAfterManualRelease() throws Exception {
        String key = "name";
        Node node = this.getGraphDb().createNode();
        this.tx.success();
        Transaction current = this.tx.begin();
        Lock nodeLock = current.acquireWriteLock((PropertyContainer)node);
        node.setProperty(key, (Object)"value");
        nodeLock.release();
        this.worker.beginTx();
        try {
            this.worker.setProperty(node, key, "ksjd");
            Assert.fail((String)"Shouldn't be able to grab it");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tx.success();
        try {
            this.worker.finishTx();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private GraphDatabaseService getGraphDb() {
        return this.db.getGraphDatabaseService();
    }

    private class Worker
    extends OtherThreadExecutor<State> {
        public Worker() {
            super("other thread", new State(ManualAcquireLockTest.this.getGraphDb()));
        }

        void beginTx() throws Exception {
            this.execute(new OtherThreadExecutor.WorkerCommand<State, Void>(){

                @Override
                public Void doWork(State state) {
                    state.tx = state.graphDb.beginTx();
                    return null;
                }
            });
        }

        void finishTx() throws Exception {
            this.execute(new OtherThreadExecutor.WorkerCommand<State, Void>(){

                @Override
                public Void doWork(State state) {
                    state.tx.success();
                    state.tx.close();
                    return null;
                }
            });
        }

        void setProperty(final Node node, final String key, final Object value) throws Exception {
            this.execute(new OtherThreadExecutor.WorkerCommand<State, Object>(){

                @Override
                public Object doWork(State state) {
                    node.setProperty(key, value);
                    return null;
                }
            }, 200L, TimeUnit.MILLISECONDS);
        }
    }

    private class State {
        private final GraphDatabaseService graphDb;
        private Transaction tx;

        public State(GraphDatabaseService graphDb) {
            this.graphDb = graphDb;
        }
    }
}

