/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class StoreVersionCheckTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();

    @Test
    public void shouldFailIfFileDoesNotExist() {
        File missingFile = new File("/you/will/never/find/me");
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs.get());
        StoreVersionCheck storeVersionCheck = new StoreVersionCheck(pageCache);
        StoreVersionCheck.Result result = storeVersionCheck.hasVersion(missingFile, "version");
        Assert.assertFalse((boolean)result.outcome.isSuccessful());
        Assert.assertEquals((Object)StoreVersionCheck.Result.Outcome.missingStoreFile, (Object)result.outcome);
        Assert.assertNull((Object)result.actualVersion);
    }

    @Test
    public void shouldReportShortFileDoesNotHaveSpecifiedVersion() throws IOException {
        File shortFile = this.fileContaining(this.fs.get(), "nothing interesting");
        StoreVersionCheck storeVersionCheck = new StoreVersionCheck(this.pageCacheRule.getPageCache(this.fs.get()));
        StoreVersionCheck.Result result = storeVersionCheck.hasVersion(shortFile, "version");
        Assert.assertFalse((boolean)result.outcome.isSuccessful());
        Assert.assertEquals((Object)StoreVersionCheck.Result.Outcome.storeVersionNotFound, (Object)result.outcome);
        Assert.assertNull((Object)result.actualVersion);
    }

    @Test
    public void shouldReportFileWithIncorrectVersion() throws IOException {
        File neoStore = this.emptyFile(this.fs.get());
        long v1 = MetaDataStore.versionStringToLong((String)"V1");
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs.get());
        MetaDataStore.setRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)v1);
        StoreVersionCheck storeVersionCheck = new StoreVersionCheck(pageCache);
        StoreVersionCheck.Result result = storeVersionCheck.hasVersion(neoStore, "V2");
        Assert.assertFalse((boolean)result.outcome.isSuccessful());
        Assert.assertEquals((Object)StoreVersionCheck.Result.Outcome.unexpectedUpgradingStoreVersion, (Object)result.outcome);
        Assert.assertEquals((Object)"V1", (Object)result.actualVersion);
    }

    @Test
    public void shouldReportFileWithCorrectVersion() throws IOException {
        File neoStore = this.emptyFile(this.fs.get());
        long v1 = MetaDataStore.versionStringToLong((String)"V1");
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs.get());
        MetaDataStore.setRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)v1);
        StoreVersionCheck storeVersionCheck = new StoreVersionCheck(pageCache);
        StoreVersionCheck.Result result = storeVersionCheck.hasVersion(neoStore, "V1");
        Assert.assertTrue((boolean)result.outcome.isSuccessful());
        Assert.assertEquals((Object)StoreVersionCheck.Result.Outcome.ok, (Object)result.outcome);
        Assert.assertNull((Object)result.actualVersion);
    }

    private File emptyFile(FileSystemAbstraction fs) throws IOException {
        File shortFile = new File("shortFile");
        fs.create(shortFile);
        return shortFile;
    }

    private File fileContaining(FileSystemAbstraction fs, String content) throws IOException {
        File shortFile = new File("shortFile");
        try (OutputStream outputStream = fs.openAsOutputStream(shortFile, true);){
            outputStream.write(UTF8.encode((String)content));
            File file = shortFile;
            return file;
        }
    }
}

