/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.util.concurrent.locks.Lock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.kvstore.ConcurrentMapState;
import org.neo4j.kernel.impl.store.kvstore.EntryUpdater;
import org.neo4j.kernel.impl.store.kvstore.ReadableState;

public class ConcurrentMapStateTest {
    private final ReadableState<?> store = (ReadableState)Mockito.mock(ReadableState.class);
    private final File file = (File)Mockito.mock(File.class);
    private final Lock lock = (Lock)Mockito.mock(Lock.class);

    @Test
    public void shouldCreateAnUpdaterForTheNextUnseenVersionUpdate() throws Exception {
        long initialVersion = 42L;
        Mockito.when((Object)this.store.version()).thenReturn((Object)initialVersion);
        ConcurrentMapState state = new ConcurrentMapState(this.store, this.file);
        long updateVersion = 43L;
        EntryUpdater updater = state.updater(updateVersion, this.lock);
        Assert.assertNotNull((Object)updater);
        Assert.assertEquals((long)updateVersion, (long)state.version());
    }

    @Test
    public void shouldCreateAnUpdaterForAnUnseenVersionUpdateWithAGap() throws Exception {
        long initialVersion = 42L;
        Mockito.when((Object)this.store.version()).thenReturn((Object)initialVersion);
        ConcurrentMapState state = new ConcurrentMapState(this.store, this.file);
        long updateVersion = 45L;
        EntryUpdater updater = state.updater(updateVersion, this.lock);
        updater.close();
        Assert.assertNotNull((Object)updater);
        Assert.assertEquals((long)updateVersion, (long)state.version());
    }

    @Test
    public void shouldCreateAnUpdaterForMultipleVersionUpdatesInOrder() throws Exception {
        long initialVersion = 42L;
        Mockito.when((Object)this.store.version()).thenReturn((Object)initialVersion);
        ConcurrentMapState state = new ConcurrentMapState(this.store, this.file);
        long updateVersion = 43L;
        EntryUpdater updater = state.updater(updateVersion, this.lock);
        updater.close();
        updateVersion = 44L;
        updater = state.updater(updateVersion, this.lock);
        updater.close();
        updateVersion = 45L;
        updater = state.updater(updateVersion, this.lock);
        updater.close();
        Assert.assertNotNull((Object)updater);
        Assert.assertEquals((long)updateVersion, (long)state.version());
    }

    @Test
    public void shouldCreateAnUpdaterForMultipleVersionUpdatesNotInOrder() throws Exception {
        long initialVersion = 42L;
        Mockito.when((Object)this.store.version()).thenReturn((Object)initialVersion);
        ConcurrentMapState state = new ConcurrentMapState(this.store, this.file);
        long updateVersion = 45L;
        EntryUpdater updater = state.updater(updateVersion, this.lock);
        updater.close();
        updateVersion = 43L;
        updater = state.updater(updateVersion, this.lock);
        updater.close();
        updateVersion = 44L;
        updater = state.updater(updateVersion, this.lock);
        updater.close();
        Assert.assertNotNull((Object)updater);
        Assert.assertEquals((long)45L, (long)state.version());
    }

    @Test
    public void shouldUseEmptyUpdaterOnVersionLowerOrEqualToTheInitialVersion() throws Exception {
        long initialVersion = 42L;
        Mockito.when((Object)this.store.version()).thenReturn((Object)initialVersion);
        ConcurrentMapState state = new ConcurrentMapState(this.store, this.file);
        EntryUpdater updater = state.updater(initialVersion, this.lock);
        Assert.assertEquals((String)"Empty updater should be used for version less or equal to initial", (Object)EntryUpdater.noUpdates(), (Object)updater);
    }
}

