/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;

public class StoreFactoryTest {
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    private StoreFactory storeFactory;
    private NeoStores neoStores;
    private File storeDir;

    @Before
    public void setUp() throws IOException {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        PageCache pageCache = this.pageCacheRule.getPageCache(fs);
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory((FileSystemAbstraction)fs);
        this.storeDir = this.testDirectory.graphDbDir();
        fs.mkdirs(this.storeDir);
        this.storeFactory = new StoreFactory(this.storeDir, new Config(), (IdGeneratorFactory)idGeneratorFactory, pageCache, (FileSystemAbstraction)fs, (LogProvider)NullLogProvider.getInstance());
    }

    @After
    public void tearDown() {
        if (this.neoStores != null) {
            this.neoStores.close();
        }
    }

    @Test
    public void shouldHaveSameCreationTimeAndUpgradeTimeOnStartup() throws Exception {
        this.neoStores = this.storeFactory.openAllNeoStores(true);
        MetaDataStore metaDataStore = this.neoStores.getMetaDataStore();
        Assert.assertThat((Object)metaDataStore.getUpgradeTime(), (Matcher)CoreMatchers.equalTo((Object)metaDataStore.getCreationTime()));
    }

    @Test
    public void shouldHaveSameCommittedTransactionAndUpgradeTransactionOnStartup() throws Exception {
        this.neoStores = this.storeFactory.openAllNeoStores(true);
        MetaDataStore metaDataStore = this.neoStores.getMetaDataStore();
        Assert.assertEquals((Object)metaDataStore.getUpgradeTransaction(), (Object)metaDataStore.getLastCommittedTransaction());
    }

    @Test
    public void shouldHaveSpecificCountsTrackerForReadOnlyDatabase() throws IOException {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        PageCache pageCache = this.pageCacheRule.getPageCache(fs);
        StoreFactory readOnlyStoreFactory = new StoreFactory(this.testDirectory.directory("readOnlyStore"), new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true"})), (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)fs), pageCache, (FileSystemAbstraction)fs, (LogProvider)NullLogProvider.getInstance());
        this.neoStores = readOnlyStoreFactory.openAllNeoStores(true);
        long lastClosedTransactionId = this.neoStores.getMetaDataStore().getLastClosedTransactionId();
        Assert.assertEquals((long)-1L, (long)this.neoStores.getCounts().rotate(lastClosedTransactionId));
    }

    @Test(expected=StoreNotFoundException.class)
    public void shouldThrowWhenOpeningNonExistingNeoStores() {
        try (NeoStores neoStores = this.storeFactory.openAllNeoStores();){
            neoStores.getMetaDataStore();
        }
    }
}

