/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.recovery;

import java.io.File;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.recovery.RecoveryRequiredChecker;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class RecoveryRequiredCheckerTest {
    private final EphemeralFileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTestWithEphemeralFS(this.fileSystem, this.getClass());
    private File storeDir;

    @Before
    public void setup() {
        this.storeDir = this.testDirectory.graphDbDir();
        new TestGraphDatabaseFactory().setFileSystem(this.fileSystem).newImpermanentDatabase(this.storeDir).shutdown();
    }

    @Test
    public void shouldNotWantToRecoverIntactStore() throws Exception {
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystem);
        RecoveryRequiredChecker recoverer = new RecoveryRequiredChecker((FileSystemAbstraction)this.fileSystem, pageCache);
        Assert.assertThat((Object)recoverer.isRecoveryRequiredAt(this.storeDir), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldWantToRecoverBrokenStore() throws Exception {
        FileSystemAbstraction fileSystemAbstraction = this.createSomeDataAndCrash(this.storeDir, this.fileSystem);
        PageCache pageCache = this.pageCacheRule.getPageCache(fileSystemAbstraction);
        RecoveryRequiredChecker recoverer = new RecoveryRequiredChecker(fileSystemAbstraction, pageCache);
        Assert.assertThat((Object)recoverer.isRecoveryRequiredAt(this.storeDir), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldBeAbleToRecoverBrokenStore() throws Exception {
        FileSystemAbstraction fileSystemAbstraction = this.createSomeDataAndCrash(this.storeDir, this.fileSystem);
        PageCache pageCache = this.pageCacheRule.getPageCache(fileSystemAbstraction);
        RecoveryRequiredChecker recoverer = new RecoveryRequiredChecker(fileSystemAbstraction, pageCache);
        Assert.assertThat((Object)recoverer.isRecoveryRequiredAt(this.storeDir), (Matcher)CoreMatchers.is((Object)true));
        new TestGraphDatabaseFactory().setFileSystem(fileSystemAbstraction).newImpermanentDatabase(this.storeDir).shutdown();
        Assert.assertThat((Object)recoverer.isRecoveryRequiredAt(this.storeDir), (Matcher)CoreMatchers.is((Object)false));
    }

    private FileSystemAbstraction createSomeDataAndCrash(File store, EphemeralFileSystemAbstraction fileSystem) throws IOException {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(fileSystem).newImpermanentDatabase(store);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        EphemeralFileSystemAbstraction snapshot = fileSystem.snapshot();
        db.shutdown();
        return snapshot;
    }
}

