/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.neo4j.kernel.impl.locking.DumpLocksVisitor;
import org.neo4j.kernel.impl.locking.LockWorker;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.logging.FormattedLogProvider;

public class LockWorkFailureDump {
    private final File file;

    public LockWorkFailureDump(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File dumpState(Locks lm, LockWorker ... workers) throws IOException {
        FileOutputStream out = new FileOutputStream(this.file, false);
        FormattedLogProvider logProvider = FormattedLogProvider.withoutAutoFlush().toOutputStream(out);
        try {
            lm.accept((Locks.Visitor)new DumpLocksVisitor(logProvider.getLog(LockWorkFailureDump.class)));
            Object log = logProvider.getLog(this.getClass());
            for (LockWorker worker : workers) {
                log.info("Worker %s", worker);
                worker.dump(log.infoLogger());
            }
            File file = this.file;
            return file;
        }
        finally {
            out.flush();
            out.close();
        }
    }
}

