/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.locking.LockClientStateHolder;

public class LockClientStateHolderTest {
    @Test
    public void shouldAllowIncrementDecrementClientsWhileNotClosed() {
        LockClientStateHolder lockClientStateHolder = new LockClientStateHolder();
        Assert.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
        Assert.assertTrue((boolean)lockClientStateHolder.incrementActiveClients());
        Assert.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        Assert.assertTrue((boolean)lockClientStateHolder.incrementActiveClients());
        Assert.assertTrue((boolean)lockClientStateHolder.incrementActiveClients());
        lockClientStateHolder.decrementActiveClients();
        lockClientStateHolder.decrementActiveClients();
        lockClientStateHolder.decrementActiveClients();
        Assert.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
    }

    @Test
    public void shouldNotAllowNewClientsWhenClosed() {
        LockClientStateHolder lockClientStateHolder = new LockClientStateHolder();
        lockClientStateHolder.stopClient();
        Assert.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
        Assert.assertFalse((boolean)lockClientStateHolder.incrementActiveClients());
    }

    @Test
    public void shouldBeAbleToDecrementActiveItemAndDetectWhenFree() {
        LockClientStateHolder lockClientStateHolder = new LockClientStateHolder();
        lockClientStateHolder.incrementActiveClients();
        lockClientStateHolder.incrementActiveClients();
        lockClientStateHolder.decrementActiveClients();
        lockClientStateHolder.incrementActiveClients();
        Assert.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.stopClient();
        Assert.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.decrementActiveClients();
        Assert.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.decrementActiveClients();
        Assert.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
    }

    @Test
    public void shouldBeAbleToResetAndReuseClientState() {
        LockClientStateHolder lockClientStateHolder = new LockClientStateHolder();
        Assert.assertTrue((boolean)lockClientStateHolder.incrementActiveClients());
        Assert.assertTrue((boolean)lockClientStateHolder.incrementActiveClients());
        lockClientStateHolder.decrementActiveClients();
        Assert.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.stopClient();
        Assert.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        Assert.assertTrue((boolean)lockClientStateHolder.isStopped());
        lockClientStateHolder.reset();
        Assert.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
        Assert.assertFalse((boolean)lockClientStateHolder.isStopped());
        Assert.assertTrue((boolean)lockClientStateHolder.incrementActiveClients());
        Assert.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        Assert.assertFalse((boolean)lockClientStateHolder.isStopped());
    }
}

