/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import java.util.ArrayList;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.event.ExpectedTransactionData;
import org.neo4j.kernel.impl.event.VerifyingTransactionEventHandler;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.RandomRule;

public class TransactionEventsIT {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldSeeExpectedTransactionData() throws Exception {
        Graph state = new Graph((GraphDatabaseService)this.db, this.random);
        ExpectedTransactionData expected = new ExpectedTransactionData(true);
        VerifyingTransactionEventHandler handler = new VerifyingTransactionEventHandler(expected);
        try (Transaction tx = this.db.beginTx();){
            int i;
            for (i = 0; i < 100; ++i) {
                Operation.createNode.perform(state, expected);
            }
            for (i = 0; i < 20; ++i) {
                Operation.createRelationship.perform(state, expected);
            }
            tx.success();
        }
        this.db.registerTransactionEventHandler(handler);
        Operation[] operations = Operation.values();
        for (int i = 0; i < 1000; ++i) {
            expected.clear();
            try (Transaction tx = this.db.beginTx();){
                int transactionSize = this.random.intBetween(1, 20);
                for (int j = 0; j < transactionSize; ++j) {
                    this.random.among(operations).perform(state, expected);
                }
                tx.success();
                continue;
            }
        }
    }

    private static class Graph {
        private static final String[] TOKENS = new String[]{"A", "B", "C", "D", "E"};
        private final GraphDatabaseService db;
        private final RandomRule random;
        private final List<Node> nodes = new ArrayList<Node>();
        private final List<Relationship> relationships = new ArrayList<Relationship>();

        Graph(GraphDatabaseService db, RandomRule random) {
            this.db = db;
            this.random = random;
        }

        private <E extends PropertyContainer> E random(List<E> entities) {
            return (E)(entities.isEmpty() ? null : (PropertyContainer)entities.get(this.random.nextInt(entities.size())));
        }

        Node randomNode() {
            return this.random(this.nodes);
        }

        Relationship randomRelationship() {
            return this.random(this.relationships);
        }

        Node createNode() {
            Node node = this.db.createNode();
            this.nodes.add(node);
            return node;
        }

        void deleteRelationship(Relationship relationship) {
            relationship.delete();
            this.relationships.remove(relationship);
        }

        void deleteNode(Node node) {
            node.delete();
            this.nodes.remove(node);
        }

        private String randomToken() {
            return this.random.among(TOKENS);
        }

        Label randomLabel() {
            return DynamicLabel.label((String)this.randomToken());
        }

        RelationshipType randomRelationshipType() {
            return DynamicRelationshipType.withName((String)this.randomToken());
        }

        String randomPropertyKey() {
            return this.randomToken();
        }

        Object randomPropertyValue() {
            return this.random.propertyValue();
        }

        int nodeCount() {
            return this.nodes.size();
        }

        Relationship createRelationship(Node node1, Node node2, RelationshipType type) {
            Relationship relationship = node1.createRelationshipTo(node2, type);
            this.relationships.add(relationship);
            return relationship;
        }
    }

    static enum Operation {
        createNode{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                Node node = graph.createNode();
                expectations.createdNode(node);
                this.debug(node);
            }
        }
        ,
        deleteNode{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                Node node = graph.randomNode();
                if (node != null) {
                    for (Relationship relationship : node.getRelationships()) {
                        graph.deleteRelationship(relationship);
                        expectations.deletedRelationship(relationship);
                        this.debug(relationship);
                    }
                    graph.deleteNode(node);
                    expectations.deletedNode(node);
                    this.debug(node);
                }
            }
        }
        ,
        assignLabel{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                Label label;
                Node node = graph.randomNode();
                if (node != null && !node.hasLabel(label = graph.randomLabel())) {
                    node.addLabel(label);
                    expectations.assignedLabel(node, label);
                    this.debug(node + " " + label);
                }
            }
        }
        ,
        removeLabel{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                Label label;
                Node node = graph.randomNode();
                if (node != null && node.hasLabel(label = graph.randomLabel())) {
                    node.removeLabel(label);
                    expectations.removedLabel(node, label);
                    this.debug(node + " " + label);
                }
            }
        }
        ,
        setNodeProperty{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                Node node = graph.randomNode();
                if (node != null) {
                    String key = graph.randomPropertyKey();
                    Object valueBefore = node.getProperty(key, null);
                    Object value = graph.randomPropertyValue();
                    node.setProperty(key, value);
                    expectations.assignedProperty(node, key, value, valueBefore);
                    this.debug(node + " " + key + "=" + value + " prev " + valueBefore);
                }
            }
        }
        ,
        removeNodeProperty{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                String key;
                Node node = graph.randomNode();
                if (node != null && node.hasProperty(key = graph.randomPropertyKey())) {
                    Object valueBefore = node.removeProperty(key);
                    expectations.removedProperty(node, key, valueBefore);
                    this.debug(node + " " + key + "=" + valueBefore);
                }
            }
        }
        ,
        setRelationshipProperty{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                Relationship relationship = graph.randomRelationship();
                if (relationship != null) {
                    String key = graph.randomPropertyKey();
                    Object valueBefore = relationship.getProperty(key, null);
                    Object value = graph.randomPropertyValue();
                    relationship.setProperty(key, value);
                    expectations.assignedProperty(relationship, key, value, valueBefore);
                    this.debug(relationship + " " + key + "=" + value + " prev " + valueBefore);
                }
            }
        }
        ,
        removeRelationshipProperty{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                String key;
                Relationship relationship = graph.randomRelationship();
                if (relationship != null && relationship.hasProperty(key = graph.randomPropertyKey())) {
                    Object valueBefore = relationship.removeProperty(key);
                    expectations.removedProperty(relationship, key, valueBefore);
                    this.debug(relationship + " " + key + "=" + valueBefore);
                }
            }
        }
        ,
        createRelationship{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                while (graph.nodeCount() < 2) {
                    createNode.perform(graph, expectations);
                }
                Node node1 = graph.randomNode();
                Node node2 = graph.randomNode();
                Relationship relationship = graph.createRelationship(node1, node2, graph.randomRelationshipType());
                expectations.createdRelationship(relationship);
                this.debug(relationship);
            }
        }
        ,
        deleteRelationship{

            @Override
            void perform(Graph graph, ExpectedTransactionData expectations) {
                Relationship relationship = graph.randomRelationship();
                if (relationship != null) {
                    graph.deleteRelationship(relationship);
                    expectations.deletedRelationship(relationship);
                    this.debug(relationship);
                }
            }
        };


        abstract void perform(Graph var1, ExpectedTransactionData var2);

        void debug(Object value) {
        }
    }
}

