/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.Triplet;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.event.ExpectedTransactionData;
import org.neo4j.kernel.impl.event.VerifyingTransactionEventHandler;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.TestLabels;

public class TestTransactionEvents {
    @Rule
    public final DatabaseRule dbRule = new ImpermanentDatabaseRule();

    @Test
    public void testRegisterUnregisterHandlers() {
        Integer value1 = 10;
        Double value2 = 3.5;
        DummyTransactionEventHandler<Integer> handler1 = new DummyTransactionEventHandler<Integer>(value1);
        DummyTransactionEventHandler<Double> handler2 = new DummyTransactionEventHandler<Double>(value2);
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        try {
            db.unregisterTransactionEventHandler(handler1);
            Assert.fail((String)"Shouldn't be able to do unregister on a unregistered handler");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertTrue((handler1 == db.registerTransactionEventHandler(handler1) ? 1 : 0) != 0);
        Assert.assertTrue((handler1 == db.registerTransactionEventHandler(handler1) ? 1 : 0) != 0);
        Assert.assertTrue((handler1 == db.unregisterTransactionEventHandler(handler1) ? 1 : 0) != 0);
        try {
            db.unregisterTransactionEventHandler(handler1);
            Assert.fail((String)"Shouldn't be able to do unregister on a unregistered handler");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertTrue((handler1 == db.registerTransactionEventHandler(handler1) ? 1 : 0) != 0);
        Assert.assertTrue((handler2 == db.registerTransactionEventHandler(handler2) ? 1 : 0) != 0);
        Assert.assertTrue((handler1 == db.unregisterTransactionEventHandler(handler1) ? 1 : 0) != 0);
        Assert.assertTrue((handler2 == db.unregisterTransactionEventHandler(handler2) ? 1 : 0) != 0);
        db.registerTransactionEventHandler(handler1);
        try (Transaction tx = db.beginTx();){
            db.createNode().delete();
            tx.success();
        }
        Assert.assertNotNull((Object)((DummyTransactionEventHandler)handler1).beforeCommit);
        Assert.assertNotNull((Object)((DummyTransactionEventHandler)handler1).afterCommit);
        Assert.assertNull((Object)((DummyTransactionEventHandler)handler1).afterRollback);
        Assert.assertEquals((Object)value1, (Object)((DummyTransactionEventHandler)handler1).receivedState);
        Assert.assertNotNull((Object)((DummyTransactionEventHandler)handler1).receivedTransactionData);
        db.unregisterTransactionEventHandler(handler1);
    }

    @Test
    public void makeSureHandlersCantBeRegisteredTwice() {
        DummyTransactionEventHandler<Object> handler = new DummyTransactionEventHandler<Object>(null);
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        db.registerTransactionEventHandler(handler);
        db.registerTransactionEventHandler(handler);
        try (Transaction tx = db.beginTx();){
            db.createNode().delete();
            tx.success();
        }
        Assert.assertEquals((Object)0, (Object)((DummyTransactionEventHandler)handler).beforeCommit);
        Assert.assertEquals((Object)1, (Object)((DummyTransactionEventHandler)handler).afterCommit);
        Assert.assertNull((Object)((DummyTransactionEventHandler)handler).afterRollback);
        db.unregisterTransactionEventHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldGetCorrectTransactionDataUponCommit() {
        Throwable failure;
        Throwable throwable;
        Transaction tx;
        ExpectedTransactionData expectedData = new ExpectedTransactionData();
        VerifyingTransactionEventHandler handler = new VerifyingTransactionEventHandler(expectedData);
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        db.registerTransactionEventHandler((TransactionEventHandler)handler);
        Node node1 = null;
        Node node3 = null;
        Relationship rel1 = null;
        Relationship rel2 = null;
        try {
            tx = db.beginTx();
            throwable = null;
            try {
                node1 = db.createNode();
                expectedData.expectedCreatedNodes.add(node1);
                Node node2 = db.createNode();
                expectedData.expectedCreatedNodes.add(node2);
                rel1 = node1.createRelationshipTo(node2, (RelationshipType)RelTypes.TXEVENT);
                expectedData.expectedCreatedRelationships.add(rel1);
                node1.setProperty("name", (Object)"Mattias");
                expectedData.assignedProperty(node1, "name", (Object)"Mattias", null);
                node1.setProperty("last name", (Object)"Persson");
                expectedData.assignedProperty(node1, "last name", (Object)"Persson", null);
                node1.setProperty("counter", (Object)10);
                expectedData.assignedProperty(node1, "counter", (Object)10, null);
                rel1.setProperty("description", (Object)"A description");
                expectedData.assignedProperty(rel1, "description", (Object)"A description", null);
                rel1.setProperty("number", (Object)4.5);
                expectedData.assignedProperty(rel1, "number", (Object)4.5, null);
                node3 = db.createNode();
                expectedData.expectedCreatedNodes.add(node3);
                rel2 = node3.createRelationshipTo(node2, (RelationshipType)RelTypes.TXEVENT);
                expectedData.expectedCreatedRelationships.add(rel2);
                node3.setProperty("name", (Object)"Node 3");
                expectedData.assignedProperty(node3, "name", (Object)"Node 3", null);
                tx.success();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            Assert.assertTrue((String)"Should have been invoked", (boolean)handler.hasBeenCalled());
            failure = handler.failure();
            if (failure != null) {
                throw new RuntimeException(failure);
            }
        }
        finally {
            db.unregisterTransactionEventHandler((TransactionEventHandler)handler);
        }
        expectedData = new ExpectedTransactionData();
        handler = new VerifyingTransactionEventHandler(expectedData);
        db.registerTransactionEventHandler((TransactionEventHandler)handler);
        try {
            tx = db.beginTx();
            throwable = null;
            try {
                Node newNode = db.createNode();
                expectedData.expectedCreatedNodes.add(newNode);
                Node tempNode = db.createNode();
                Relationship tempRel = tempNode.createRelationshipTo(node1, (RelationshipType)RelTypes.TXEVENT);
                tempNode.setProperty("something", (Object)"Some value");
                tempRel.setProperty("someproperty", (Object)101010);
                tempNode.removeProperty("nothing");
                node3.setProperty("test", (Object)"hello");
                node3.setProperty("name", (Object)"No name");
                node3.delete();
                expectedData.expectedDeletedNodes.add(node3);
                expectedData.removedProperty(node3, "name", (Object)"Node 3");
                node1.setProperty("new name", (Object)"A name");
                node1.setProperty("new name", (Object)"A better name");
                expectedData.assignedProperty(node1, "new name", (Object)"A better name", null);
                node1.setProperty("name", (Object)"Nothing");
                node1.setProperty("name", (Object)"Mattias Persson");
                expectedData.assignedProperty(node1, "name", (Object)"Mattias Persson", (Object)"Mattias");
                node1.removeProperty("counter");
                expectedData.removedProperty(node1, "counter", (Object)10);
                node1.removeProperty("last name");
                node1.setProperty("last name", (Object)"Hi");
                expectedData.assignedProperty(node1, "last name", (Object)"Hi", (Object)"Persson");
                rel2.delete();
                expectedData.expectedDeletedRelationships.add(rel2);
                rel1.removeProperty("number");
                expectedData.removedProperty(rel1, "number", (Object)4.5);
                rel1.setProperty("description", (Object)"Ignored");
                rel1.setProperty("description", (Object)"New");
                expectedData.assignedProperty(rel1, "description", (Object)"New", (Object)"A description");
                tempRel.delete();
                tempNode.delete();
                tx.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            Assert.assertTrue((String)"Should have been invoked", (boolean)handler.hasBeenCalled());
            failure = handler.failure();
            if (failure != null) {
                throw new RuntimeException(failure);
            }
        }
        finally {
            db.unregisterTransactionEventHandler((TransactionEventHandler)handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void makeSureBeforeAfterAreCalledCorrectly() {
        ArrayList<TransactionEventHandler<Object>> handlers = new ArrayList<TransactionEventHandler<Object>>();
        handlers.add(new FailingEventHandler<Object>(new DummyTransactionEventHandler<Object>(null), false));
        handlers.add(new FailingEventHandler<Object>(new DummyTransactionEventHandler<Object>(null), false));
        handlers.add(new FailingEventHandler<Object>(new DummyTransactionEventHandler<Object>(null), true));
        handlers.add(new FailingEventHandler<Object>(new DummyTransactionEventHandler<Object>(null), false));
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        for (TransactionEventHandler transactionEventHandler : handlers) {
            db.registerTransactionEventHandler(transactionEventHandler);
        }
        try {
            Transaction tx = db.beginTx();
            try {
                db.createNode().delete();
                tx.success();
                tx.close();
                Assert.fail((String)"Should fail commit");
            }
            catch (TransactionFailureException transactionFailureException) {
                // empty catch block
            }
            this.verifyHandlerCalls(handlers, false);
            db.unregisterTransactionEventHandler((TransactionEventHandler)handlers.remove(2));
            for (TransactionEventHandler transactionEventHandler : handlers) {
                ((DummyTransactionEventHandler)((FailingEventHandler)transactionEventHandler).source).reset();
            }
            Throwable throwable = null;
            try (Transaction transaction = db.beginTx();){
                db.createNode().delete();
                transaction.success();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            this.verifyHandlerCalls(handlers, true);
        }
        finally {
            for (TransactionEventHandler transactionEventHandler : handlers) {
                db.unregisterTransactionEventHandler(transactionEventHandler);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Test
    public void shouldBeAbleToAccessExceptionThrownInEventHook() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void deleteNodeRelTriggerPropertyRemoveEvents() {
        Relationship rel;
        Node node2;
        Node node1;
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        try (Transaction tx = db.beginTx();){
            node1 = db.createNode();
            node2 = db.createNode();
            rel = node1.createRelationshipTo(node2, (RelationshipType)RelTypes.TXEVENT);
            node1.setProperty("test1", (Object)"stringvalue");
            node1.setProperty("test2", (Object)1L);
            rel.setProperty("test1", (Object)"stringvalue");
            rel.setProperty("test2", (Object)1L);
            rel.setProperty("test3", (Object)new int[]{1, 2, 3});
            tx.success();
        }
        MyTxEventHandler handler = new MyTxEventHandler();
        db.registerTransactionEventHandler((TransactionEventHandler)handler);
        try (Transaction tx = db.beginTx();){
            GraphDatabaseAPI dbApi = this.dbRule.getGraphDatabaseAPI();
            rel.delete();
            node1.delete();
            node2.delete();
            tx.success();
        }
        Assert.assertEquals((Object)"stringvalue", (Object)handler.nodeProps.get("test1"));
        Assert.assertEquals((Object)"stringvalue", (Object)handler.relProps.get("test1"));
        Assert.assertEquals((Object)1L, (Object)handler.nodeProps.get("test2"));
        Assert.assertEquals((Object)1L, (Object)handler.relProps.get("test2"));
        int[] intArray = (int[])handler.relProps.get("test3");
        Assert.assertEquals((long)3L, (long)intArray.length);
        Assert.assertEquals((long)1L, (long)intArray[0]);
        Assert.assertEquals((long)2L, (long)intArray[1]);
        Assert.assertEquals((long)3L, (long)intArray[2]);
    }

    private void verifyHandlerCalls(List<TransactionEventHandler<Object>> handlers, boolean txSuccess) {
        for (TransactionEventHandler<Object> handler : handlers) {
            DummyTransactionEventHandler realHandler = (DummyTransactionEventHandler)((FailingEventHandler)handler).source;
            if (txSuccess) {
                Assert.assertEquals((Object)0, (Object)realHandler.beforeCommit);
                Assert.assertEquals((Object)1, (Object)realHandler.afterCommit);
                continue;
            }
            if (realHandler.counter <= 0) continue;
            Assert.assertEquals((Object)0, (Object)realHandler.beforeCommit);
            Assert.assertEquals((Object)1, (Object)realHandler.afterRollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void makeSureHandlerIsntCalledWhenTxRolledBack() {
        DummyTransactionEventHandler<Integer> handler = new DummyTransactionEventHandler<Integer>(10);
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        db.registerTransactionEventHandler(handler);
        try {
            try (Transaction ignore = db.beginTx();){
                db.createNode().delete();
            }
            Assert.assertNull((Object)((DummyTransactionEventHandler)handler).beforeCommit);
            Assert.assertNull((Object)((DummyTransactionEventHandler)handler).afterCommit);
            Assert.assertNull((Object)((DummyTransactionEventHandler)handler).afterRollback);
        }
        finally {
            db.unregisterTransactionEventHandler(handler);
        }
    }

    @Test
    public void modifiedPropertyCanByFurtherModifiedInBeforeCommit() throws Exception {
        Node node;
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        String key = "key";
        String value1 = "the old value";
        final String value2 = "the new value";
        try (Transaction tx = db.beginTx();){
            node = db.createNode();
            node.setProperty("key", (Object)"initial value");
            tx.success();
        }
        TransactionEventHandler.Adapter<Void> handler = new TransactionEventHandler.Adapter<Void>(){

            public Void beforeCommit(TransactionData data) throws Exception {
                Node modifiedNode = (Node)((PropertyEntry)data.assignedNodeProperties().iterator().next()).entity();
                Assert.assertEquals((Object)node, (Object)modifiedNode);
                modifiedNode.setProperty("key", value2);
                return null;
            }
        };
        db.registerTransactionEventHandler((TransactionEventHandler)handler);
        try (Transaction tx = db.beginTx();){
            node.setProperty("key", (Object)value1);
            tx.success();
        }
        Assert.assertThat((Object)node, Neo4jMatchers.inTx(db, Neo4jMatchers.hasProperty("key").withValue(value2)));
        db.unregisterTransactionEventHandler((TransactionEventHandler)handler);
    }

    @Test
    public void nodeCanBecomeSchemaIndexableInBeforeCommitByAddingProperty() throws Exception {
        Node node;
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        Label label = DynamicLabel.label((String)"Label");
        try (Transaction tx = db.beginTx();){
            IndexDefinition index = db.schema().indexFor(label).on("indexed").create();
            tx.success();
        }
        db.registerTransactionEventHandler((TransactionEventHandler)new TransactionEventHandler.Adapter<Object>(){

            public Object beforeCommit(TransactionData data) throws Exception {
                Iterator nodes = data.createdNodes().iterator();
                if (nodes.hasNext()) {
                    Node node = (Node)nodes.next();
                    node.setProperty("indexed", (Object)"value");
                }
                return null;
            }
        });
        tx = db.beginTx();
        var5_4 = null;
        try {
            db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            node = db.createNode(new Label[]{label});
            node.setProperty("random", (Object)42);
            tx.success();
        }
        catch (Throwable x2) {
            var5_4 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var5_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_4.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var5_4 = null;
        try (Transaction ignore = db.beginTx();){
            node = db.findNode(label, "indexed", (Object)"value");
            Assert.assertThat((Object)node.getProperty("random"), (Matcher)Matchers.is((Object)42));
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void nodeCanBecomeSchemaIndexableInBeforeCommitByAddingLabel() throws Exception {
        Node node;
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        final Label label = DynamicLabel.label((String)"Label");
        try (Transaction tx = db.beginTx();){
            IndexDefinition index = db.schema().indexFor(label).on("indexed").create();
            tx.success();
        }
        db.registerTransactionEventHandler((TransactionEventHandler)new TransactionEventHandler.Adapter<Object>(){

            public Object beforeCommit(TransactionData data) throws Exception {
                Iterator nodes = data.createdNodes().iterator();
                if (nodes.hasNext()) {
                    Node node = (Node)nodes.next();
                    node.addLabel(label);
                }
                return null;
            }
        });
        tx = db.beginTx();
        var5_4 = null;
        try {
            db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            node = db.createNode();
            node.setProperty("indexed", (Object)"value");
            node.setProperty("random", (Object)42);
            tx.success();
        }
        catch (Throwable x2) {
            var5_4 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var5_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_4.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var5_4 = null;
        try (Transaction ignore = db.beginTx();){
            node = db.findNode(label, "indexed", (Object)"value");
            Assert.assertThat((Object)node.getProperty("random"), (Matcher)Matchers.is((Object)42));
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAccessAssignedLabels() throws Exception {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        ChangedLabels labels = (ChangedLabels)db.registerTransactionEventHandler((TransactionEventHandler)new ChangedLabels());
        try {
            try (Transaction tx = db.beginTx();){
                Node node1 = db.createNode();
                Node node2 = db.createNode();
                Node node3 = db.createNode();
                labels.add(node1, "Foo");
                labels.add(node2, "Bar");
                labels.add(node3, "Baz");
                labels.add(node3, "Bar");
                labels.activate();
                tx.success();
            }
            Assert.assertTrue((boolean)labels.isEmpty());
        }
        finally {
            db.unregisterTransactionEventHandler((TransactionEventHandler)labels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAccessRemovedLabels() throws Exception {
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        ChangedLabels labels = (ChangedLabels)db.registerTransactionEventHandler((TransactionEventHandler)new ChangedLabels());
        try {
            Node node3;
            Node node2;
            Node node1;
            try (Transaction tx = db.beginTx();){
                node1 = db.createNode();
                node2 = db.createNode();
                node3 = db.createNode();
                labels.add(node1, "Foo");
                labels.add(node2, "Bar");
                labels.add(node3, "Baz");
                labels.add(node3, "Bar");
                tx.success();
            }
            labels.clear();
            tx = db.beginTx();
            var7_4 = null;
            try {
                labels.remove(node1, "Foo");
                labels.remove(node2, "Bar");
                labels.remove(node3, "Baz");
                labels.remove(node3, "Bar");
                labels.activate();
                tx.success();
            }
            catch (Throwable throwable) {
                var7_4 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var7_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            var7_4.addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            Assert.assertTrue((boolean)labels.isEmpty());
        }
        finally {
            db.unregisterTransactionEventHandler((TransactionEventHandler)labels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAccessRelationshipDataInAfterCommit() throws Exception {
        final GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        final AtomicInteger accessCount = new AtomicInteger();
        final HashMap<Long, Triplet> expectedRelationshipData = new HashMap<Long, Triplet>();
        TransactionEventHandler.Adapter<Void> handler = new TransactionEventHandler.Adapter<Void>(){

            public void afterCommit(TransactionData data, Void state) {
                accessCount.set(0);
                try (Transaction tx = db.beginTx();){
                    for (Relationship relationship : data.createdRelationships()) {
                        this.accessData(relationship);
                    }
                    for (PropertyEntry change : data.assignedRelationshipProperties()) {
                        this.accessData((Relationship)change.entity());
                    }
                    for (PropertyEntry change : data.removedRelationshipProperties()) {
                        this.accessData((Relationship)change.entity());
                    }
                    tx.success();
                }
            }

            private void accessData(Relationship relationship) {
                accessCount.incrementAndGet();
                Triplet expectancy = (Triplet)expectedRelationshipData.get(relationship.getId());
                Assert.assertNotNull((Object)expectancy);
                Assert.assertEquals((Object)expectancy.first(), (Object)relationship.getStartNode());
                Assert.assertEquals((Object)expectancy.second(), (Object)relationship.getType().name());
                Assert.assertEquals((Object)expectancy.third(), (Object)relationship.getEndNode());
            }
        };
        db.registerTransactionEventHandler((TransactionEventHandler)handler);
        try {
            Relationship relationship;
            try (Transaction tx = db.beginTx();){
                relationship = db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
                expectedRelationshipData.put(relationship.getId(), Triplet.of((Object)relationship.getStartNode(), (Object)relationship.getType().name(), (Object)relationship.getEndNode()));
                tx.success();
            }
            Assert.assertEquals((long)1L, (long)accessCount.get());
            tx = db.beginTx();
            var7_6 = null;
            try {
                relationship.setProperty("name", (Object)"Smith");
                Relationship otherRelationship = db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST2);
                expectedRelationshipData.put(otherRelationship.getId(), Triplet.of((Object)otherRelationship.getStartNode(), (Object)otherRelationship.getType().name(), (Object)otherRelationship.getEndNode()));
                tx.success();
            }
            catch (Throwable x2) {
                var7_6 = x2;
                throw x2;
            }
            finally {
                if (tx != null) {
                    if (var7_6 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            var7_6.addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            Assert.assertEquals((long)2L, (long)accessCount.get());
            tx = db.beginTx();
            var7_6 = null;
            try {
                relationship.delete();
                tx.success();
            }
            catch (Throwable throwable) {
                var7_6 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var7_6 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable x2) {
                            var7_6.addSuppressed(x2);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            Assert.assertEquals((long)1L, (long)accessCount.get());
        }
        finally {
            db.unregisterTransactionEventHandler((TransactionEventHandler)handler);
        }
    }

    @Test
    public void shouldProvideTheCorrectRelationshipData() {
        long relId;
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        try (Transaction tx = db.beginTx();){
            db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"TYPE"));
        }
        DynamicRelationshipType livesIn = DynamicRelationshipType.withName((String)"LIVES_IN");
        try (Transaction tx = db.beginTx();){
            Node person = db.createNode(new Label[]{DynamicLabel.label((String)"Person")});
            Node city = db.createNode(new Label[]{DynamicLabel.label((String)"City")});
            Relationship rel = person.createRelationshipTo(city, (RelationshipType)livesIn);
            rel.setProperty("since", (Object)2009);
            relId = rel.getId();
            tx.success();
        }
        final HashSet changedRelationships = new HashSet();
        db.registerTransactionEventHandler((TransactionEventHandler)new TransactionEventHandler.Adapter<Void>(){

            public Void beforeCommit(TransactionData data) throws Exception {
                for (PropertyEntry entry : data.assignedRelationshipProperties()) {
                    changedRelationships.add(((Relationship)entry.entity()).getType().name());
                }
                return null;
            }
        });
        try (Transaction tx = db.beginTx();){
            Relationship rel = db.getRelationshipById(relId);
            rel.setProperty("since", (Object)2010);
            tx.success();
        }
        Assert.assertEquals((long)1L, (long)changedRelationships.size());
        Assert.assertTrue((String)(livesIn + " not in " + ((Object)changedRelationships).toString()), (boolean)changedRelationships.contains(livesIn.name()));
    }

    @Test
    public void shouldNotFireEventForReadOnlyTransaction() throws Exception {
        Node root = this.createTree(3, 3);
        this.dbRule.getGraphDatabaseService().registerTransactionEventHandler((TransactionEventHandler)new ExceptionThrowingEventHandler(new RuntimeException("Just failing")));
        try (Transaction tx = this.dbRule.beginTx();){
            Iterables.count((Iterable)this.dbRule.getGraphDatabaseService().traversalDescription().traverse(root));
            tx.success();
        }
    }

    @Test
    public void shouldNotFireEventForNonDataTransactions() throws Exception {
        final AtomicInteger counter = new AtomicInteger();
        this.dbRule.getGraphDatabaseService().registerTransactionEventHandler((TransactionEventHandler)new TransactionEventHandler.Adapter<Void>(){

            public Void beforeCommit(TransactionData data) throws Exception {
                Assert.assertTrue((String)"Expected only transactions that had nodes or relationships created", (data.createdNodes().iterator().hasNext() || data.createdRelationships().iterator().hasNext() ? 1 : 0) != 0);
                counter.incrementAndGet();
                return null;
            }
        });
        Label label = DynamicLabel.label((String)"Label");
        String key = "key";
        Assert.assertEquals((long)0L, (long)counter.get());
        try (Transaction tx = this.dbRule.beginTx();){
            this.dbRule.createNode(label);
            tx.success();
        }
        Assert.assertEquals((long)1L, (long)counter.get());
        tx = this.dbRule.beginTx();
        var5_5 = null;
        try {
            this.dbRule.createNode().setProperty(key, (Object)"value");
            tx.success();
        }
        catch (Throwable x2) {
            var5_5 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertEquals((long)2L, (long)counter.get());
        tx = this.dbRule.beginTx();
        var5_5 = null;
        try {
            this.dbRule.createNode().createRelationshipTo(this.dbRule.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"A_TYPE"));
            tx.success();
        }
        catch (Throwable x2) {
            var5_5 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertEquals((long)3L, (long)counter.get());
        tx = this.dbRule.beginTx();
        var5_5 = null;
        try {
            this.dbRule.schema().indexFor(label).on(key).create();
            tx.success();
        }
        catch (Throwable x2) {
            var5_5 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.dbRule.beginTx();
        var5_5 = null;
        try {
            this.dbRule.schema().constraintFor(label).assertPropertyIsUnique("otherkey").create();
            tx.success();
        }
        catch (Throwable x2) {
            var5_5 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.dbRule.beginTx();
        var5_5 = null;
        try {
            this.dbRule.index().forNodes("some index", MapUtil.stringMap((String[])new String[]{"provider", "test-dummy-neo-index"}));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_5.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertEquals((long)3L, (long)counter.get());
    }

    @Test
    public void shouldBeAbleToTouchDataOutsideTxDataInAfterCommit() throws Exception {
        final Node node = this.createNode("one", "Two", "three", "Four");
        this.dbRule.getGraphDatabaseService().registerTransactionEventHandler((TransactionEventHandler)new TransactionEventHandler.Adapter<Object>(){

            public void afterCommit(TransactionData data, Object nothing) {
                try (Transaction tx = TestTransactionEvents.this.dbRule.beginTx();){
                    for (String key : node.getPropertyKeys()) {
                        node.getProperty(key);
                    }
                    tx.success();
                }
            }
        });
        try (Transaction tx = this.dbRule.beginTx();){
            this.dbRule.createNode();
            node.setProperty("five", (Object)"Six");
            tx.success();
        }
    }

    private Node createNode(String ... properties) {
        try (Transaction tx = this.dbRule.beginTx();){
            Node node = this.dbRule.createNode();
            for (int i = 0; i < properties.length; ++i) {
                node.setProperty(properties[i++], (Object)properties[i]);
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private Node createTree(int depth, int width) {
        try (Transaction tx = this.dbRule.beginTx();){
            Node root = this.dbRule.createNode(TestLabels.LABEL_ONE);
            this.createTree(root, depth, width, 0);
            tx.success();
            Node node = root;
            return node;
        }
    }

    private void createTree(Node parent, int maxDepth, int width, int currentDepth) {
        if (currentDepth > maxDepth) {
            return;
        }
        for (int i = 0; i < width; ++i) {
            Node child = this.dbRule.createNode(TestLabels.LABEL_TWO);
            parent.createRelationshipTo(child, (RelationshipType)MyRelTypes.TEST);
            this.createTree(child, maxDepth, width, currentDepth + 1);
        }
    }

    private static final class ChangedLabels
    extends TransactionEventHandler.Adapter<Void> {
        private final Map<Node, Set<String>> added = new HashMap<Node, Set<String>>();
        private final Map<Node, Set<String>> removed = new HashMap<Node, Set<String>>();
        private boolean active = false;

        private ChangedLabels() {
        }

        public Void beforeCommit(TransactionData data) throws Exception {
            if (this.active) {
                this.check(this.added, "added to", data.assignedLabels());
                this.check(this.removed, "removed from", data.removedLabels());
            }
            this.active = false;
            return null;
        }

        private void check(Map<Node, Set<String>> expected, String change, Iterable<LabelEntry> changes) {
            for (LabelEntry entry : changes) {
                Set<String> labels = expected.get(entry.node());
                String message = String.format("':%s' should not be %s %s", entry.label().name(), change, entry.node());
                Assert.assertNotNull((String)message, labels);
                Assert.assertTrue((String)message, (boolean)labels.remove(entry.label().name()));
                if (!labels.isEmpty()) continue;
                expected.remove(entry.node());
            }
            Assert.assertTrue((String)String.format("Expected more labels %s nodes: %s", change, expected), (boolean)expected.isEmpty());
        }

        public boolean isEmpty() {
            return this.added.isEmpty() && this.removed.isEmpty();
        }

        public void add(Node node, String label) {
            node.addLabel(DynamicLabel.label((String)label));
            this.put(this.added, node, label);
        }

        public void remove(Node node, String label) {
            node.removeLabel(DynamicLabel.label((String)label));
            this.put(this.removed, node, label);
        }

        private void put(Map<Node, Set<String>> changes, Node node, String label) {
            Set<String> labels = changes.get(node);
            if (labels == null) {
                labels = new HashSet<String>();
                changes.put(node, labels);
            }
            labels.add(label);
        }

        public void activate() {
            Assert.assertFalse((boolean)this.isEmpty());
            this.active = true;
        }

        public void clear() {
            this.added.clear();
            this.removed.clear();
            this.active = false;
        }
    }

    private static class DummyTransactionEventHandler<T>
    implements TransactionEventHandler<T> {
        private final T object;
        private TransactionData receivedTransactionData;
        private T receivedState;
        private int counter;
        private Integer beforeCommit;
        private Integer afterCommit;
        private Integer afterRollback;

        public DummyTransactionEventHandler(T object) {
            this.object = object;
        }

        public void afterCommit(TransactionData data, T state) {
            Assert.assertNotNull((Object)data);
            this.receivedState = state;
            this.afterCommit = this.counter++;
        }

        public void afterRollback(TransactionData data, T state) {
            Assert.assertNotNull((Object)data);
            this.receivedState = state;
            this.afterRollback = this.counter++;
        }

        public T beforeCommit(TransactionData data) throws Exception {
            Assert.assertNotNull((Object)data);
            this.receivedTransactionData = data;
            this.beforeCommit = this.counter++;
            if (this.beforeCommit == 2) {
                new Exception("blabla").printStackTrace();
            }
            return this.object;
        }

        void reset() {
            this.receivedTransactionData = null;
            this.receivedState = null;
            this.counter = 0;
            this.beforeCommit = null;
            this.afterCommit = null;
            this.afterRollback = null;
        }
    }

    private static class ExceptionThrowingEventHandler
    implements TransactionEventHandler<Object> {
        private final Exception beforeCommitException;
        private final Exception afterCommitException;
        private final Exception afterRollbackException;

        public ExceptionThrowingEventHandler(Exception exceptionForAll) {
            this(exceptionForAll, exceptionForAll, exceptionForAll);
        }

        public ExceptionThrowingEventHandler(Exception beforeCommitException, Exception afterCommitException, Exception afterRollbackException) {
            this.beforeCommitException = beforeCommitException;
            this.afterCommitException = afterCommitException;
            this.afterRollbackException = afterRollbackException;
        }

        public Object beforeCommit(TransactionData data) throws Exception {
            if (this.beforeCommitException != null) {
                throw this.beforeCommitException;
            }
            return null;
        }

        public void afterCommit(TransactionData data, Object state) {
            if (this.afterCommitException != null) {
                throw new RuntimeException(this.afterCommitException);
            }
        }

        public void afterRollback(TransactionData data, Object state) {
            if (this.afterRollbackException != null) {
                throw new RuntimeException(this.afterRollbackException);
            }
        }
    }

    private static class FailingEventHandler<T>
    implements TransactionEventHandler<T> {
        private final TransactionEventHandler<T> source;
        private final boolean willFail;

        public FailingEventHandler(TransactionEventHandler<T> source, boolean willFail) {
            this.source = source;
            this.willFail = willFail;
        }

        public void afterCommit(TransactionData data, T state) {
            this.source.afterCommit(data, state);
        }

        public void afterRollback(TransactionData data, T state) {
            this.source.afterRollback(data, state);
        }

        public T beforeCommit(TransactionData data) throws Exception {
            if (this.willFail) {
                throw new Exception("Just failing commit, that's all");
            }
            return (T)this.source.beforeCommit(data);
        }
    }

    private static enum RelTypes implements RelationshipType
    {
        TXEVENT;

    }

    private static class MyTxEventHandler
    implements TransactionEventHandler<Object> {
        Map<String, Object> nodeProps = new HashMap<String, Object>();
        Map<String, Object> relProps = new HashMap<String, Object>();

        private MyTxEventHandler() {
        }

        public void afterCommit(TransactionData data, Object state) {
            for (PropertyEntry entry : data.removedNodeProperties()) {
                String key = entry.key();
                Object value = entry.previouslyCommitedValue();
                this.nodeProps.put(key, value);
            }
            for (PropertyEntry entry : data.removedRelationshipProperties()) {
                this.relProps.put(entry.key(), entry.previouslyCommitedValue());
            }
        }

        public void afterRollback(TransactionData data, Object state) {
        }

        public Object beforeCommit(TransactionData data) throws Exception {
            return null;
        }
    }
}

