/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.kernel.impl.event.PropertyEntryImpl;
import org.neo4j.kernel.impl.util.AutoCreatingHashMap;

class ExpectedTransactionData {
    final Set<Node> expectedCreatedNodes = new HashSet<Node>();
    final Set<Relationship> expectedCreatedRelationships = new HashSet<Relationship>();
    final Set<Node> expectedDeletedNodes = new HashSet<Node>();
    final Set<Relationship> expectedDeletedRelationships = new HashSet<Relationship>();
    final Map<Node, Map<String, PropertyEntryImpl<Node>>> expectedAssignedNodeProperties = new AutoCreatingHashMap<Node, Map<String, Map<String, PropertyEntryImpl<Node>>>>(AutoCreatingHashMap.nested(String.class, AutoCreatingHashMap.dontCreate()));
    final Map<Relationship, Map<String, PropertyEntryImpl<Relationship>>> expectedAssignedRelationshipProperties = new AutoCreatingHashMap<Relationship, Map<String, Map<String, PropertyEntryImpl<Relationship>>>>(AutoCreatingHashMap.nested(String.class, AutoCreatingHashMap.dontCreate()));
    final Map<Node, Map<String, PropertyEntryImpl<Node>>> expectedRemovedNodeProperties = new AutoCreatingHashMap<Node, Map<String, Map<String, PropertyEntryImpl<Node>>>>(AutoCreatingHashMap.nested(String.class, AutoCreatingHashMap.dontCreate()));
    final Map<Relationship, Map<String, PropertyEntryImpl<Relationship>>> expectedRemovedRelationshipProperties = new AutoCreatingHashMap<Relationship, Map<String, Map<String, PropertyEntryImpl<Relationship>>>>(AutoCreatingHashMap.nested(String.class, AutoCreatingHashMap.dontCreate()));
    final Map<Node, Set<String>> expectedAssignedLabels = new AutoCreatingHashMap<Node, Set<Set<String>>>(AutoCreatingHashMap.valuesOfTypeHashSet());
    final Map<Node, Set<String>> expectedRemovedLabels = new AutoCreatingHashMap<Node, Set<Set<String>>>(AutoCreatingHashMap.valuesOfTypeHashSet());
    private final boolean ignoreAdditionalData;

    ExpectedTransactionData(boolean ignoreAdditionalData) {
        this.ignoreAdditionalData = ignoreAdditionalData;
    }

    ExpectedTransactionData() {
        this(false);
    }

    void clear() {
        this.expectedAssignedNodeProperties.clear();
        this.expectedAssignedRelationshipProperties.clear();
        this.expectedCreatedNodes.clear();
        this.expectedCreatedRelationships.clear();
        this.expectedDeletedNodes.clear();
        this.expectedDeletedRelationships.clear();
        this.expectedRemovedNodeProperties.clear();
        this.expectedRemovedRelationshipProperties.clear();
        this.expectedAssignedLabels.clear();
        this.expectedRemovedLabels.clear();
    }

    void createdNode(Node node) {
        this.expectedCreatedNodes.add(node);
    }

    void deletedNode(Node node) {
        if (!this.expectedCreatedNodes.remove(node)) {
            this.expectedDeletedNodes.add(node);
        }
        this.expectedAssignedNodeProperties.remove(node);
        this.expectedAssignedLabels.remove(node);
        this.expectedRemovedNodeProperties.remove(node);
        this.expectedRemovedLabels.remove(node);
    }

    void createdRelationship(Relationship relationship) {
        this.expectedCreatedRelationships.add(relationship);
    }

    void deletedRelationship(Relationship relationship) {
        if (!this.expectedCreatedRelationships.remove(relationship)) {
            this.expectedDeletedRelationships.add(relationship);
        }
        this.expectedAssignedRelationshipProperties.remove(relationship);
        this.expectedRemovedRelationshipProperties.remove(relationship);
    }

    void assignedProperty(Node node, String key, Object value, Object valueBeforeTx) {
        Map<String, PropertyEntryImpl<Node>> map;
        valueBeforeTx = this.removeProperty(this.expectedRemovedNodeProperties, node, key, valueBeforeTx);
        PropertyEntryImpl<Node> prev = (map = this.expectedAssignedNodeProperties.get(node)).get(key);
        map.put(key, this.property(node, key, value, prev != null ? prev.previouslyCommitedValue() : valueBeforeTx));
    }

    void assignedProperty(Relationship rel, String key, Object value, Object valueBeforeTx) {
        Map<String, PropertyEntryImpl<Relationship>> map;
        valueBeforeTx = this.removeProperty(this.expectedRemovedRelationshipProperties, rel, key, valueBeforeTx);
        PropertyEntryImpl<Relationship> prev = (map = this.expectedAssignedRelationshipProperties.get(rel)).get(key);
        map.put(key, this.property(rel, key, value, prev != null ? prev.previouslyCommitedValue() : valueBeforeTx));
    }

    void assignedLabel(Node node, Label label) {
        if (this.removeLabel(this.expectedRemovedLabels, node, label)) {
            this.expectedAssignedLabels.get(node).add(label.name());
        }
    }

    void removedLabel(Node node, Label label) {
        if (this.removeLabel(this.expectedAssignedLabels, node, label)) {
            this.expectedRemovedLabels.get(node).add(label.name());
        }
    }

    private boolean removeLabel(Map<Node, Set<String>> map, Node node, Label label) {
        if (map.containsKey(node)) {
            Set<String> set = map.get(node);
            if (!set.remove(label.name())) {
                return true;
            }
            if (set.isEmpty()) {
                map.remove(node);
            }
        }
        return false;
    }

    void removedProperty(Node node, String key, Object valueBeforeTx) {
        if ((valueBeforeTx = this.removeProperty(this.expectedAssignedNodeProperties, node, key, valueBeforeTx)) != null) {
            this.expectedRemovedNodeProperties.get(node).put(key, this.property(node, key, null, valueBeforeTx));
        }
    }

    void removedProperty(Relationship rel, String key, Object valueBeforeTx) {
        if ((valueBeforeTx = this.removeProperty(this.expectedAssignedRelationshipProperties, rel, key, valueBeforeTx)) != null) {
            this.expectedRemovedRelationshipProperties.get(rel).put(key, this.property(rel, key, null, valueBeforeTx));
        }
    }

    private <E extends PropertyContainer> Object removeProperty(Map<E, Map<String, PropertyEntryImpl<E>>> map, E entity, String key, Object valueBeforeTx) {
        if (map.containsKey(entity)) {
            Map<String, PropertyEntryImpl<E>> inner = map.get(entity);
            PropertyEntryImpl<E> entry = inner.remove(key);
            if (entry == null) {
                return valueBeforeTx;
            }
            if (inner.isEmpty()) {
                map.remove(entity);
            }
            if (entry.previouslyCommitedValue() != null) {
                return entry.previouslyCommitedValue();
            }
            return null;
        }
        return valueBeforeTx;
    }

    private <E extends PropertyContainer> PropertyEntryImpl<E> property(E entity, String key, Object value, Object valueBeforeTx) {
        return new PropertyEntryImpl<E>(entity, key, value, valueBeforeTx);
    }

    void compareTo(TransactionData data) {
        HashSet<Node> expectedCreatedNodes = new HashSet<Node>(this.expectedCreatedNodes);
        HashSet<Relationship> expectedCreatedRelationships = new HashSet<Relationship>(this.expectedCreatedRelationships);
        HashSet<Node> expectedDeletedNodes = new HashSet<Node>(this.expectedDeletedNodes);
        HashSet<Relationship> expectedDeletedRelationships = new HashSet<Relationship>(this.expectedDeletedRelationships);
        Map<Node, Map<String, PropertyEntryImpl<Node>>> expectedAssignedNodeProperties = this.clone(this.expectedAssignedNodeProperties);
        Map<Relationship, Map<String, PropertyEntryImpl<Relationship>>> expectedAssignedRelationshipProperties = this.clone(this.expectedAssignedRelationshipProperties);
        Map<Node, Map<String, PropertyEntryImpl<Node>>> expectedRemovedNodeProperties = this.clone(this.expectedRemovedNodeProperties);
        Map<Relationship, Map<String, PropertyEntryImpl<Relationship>>> expectedRemovedRelationshipProperties = this.clone(this.expectedRemovedRelationshipProperties);
        Map<Node, Set<String>> expectedAssignedLabels = this.cloneLabelData(this.expectedAssignedLabels);
        Map<Node, Set<String>> expectedRemovedLabels = this.cloneLabelData(this.expectedRemovedLabels);
        for (Node node : data.createdNodes()) {
            Assert.assertTrue((boolean)expectedCreatedNodes.remove(node));
            Assert.assertFalse((boolean)data.isDeleted(node));
        }
        Assert.assertTrue((String)("Expected some created nodes that weren't seen: " + expectedCreatedNodes), (boolean)expectedCreatedNodes.isEmpty());
        for (Relationship rel : data.createdRelationships()) {
            Assert.assertTrue((boolean)expectedCreatedRelationships.remove(rel));
            Assert.assertFalse((boolean)data.isDeleted(rel));
        }
        Assert.assertTrue((String)("Expected created relationships not encountered " + expectedCreatedRelationships), (boolean)expectedCreatedRelationships.isEmpty());
        for (Node node : data.deletedNodes()) {
            Assert.assertTrue((String)("Unexpected deleted node " + node), (boolean)expectedDeletedNodes.remove(node));
            Assert.assertTrue((boolean)data.isDeleted(node));
        }
        Assert.assertTrue((String)("Expected deleted nodes: " + expectedDeletedNodes), (boolean)expectedDeletedNodes.isEmpty());
        for (Relationship rel : data.deletedRelationships()) {
            Assert.assertTrue((boolean)expectedDeletedRelationships.remove(rel));
            Assert.assertTrue((boolean)data.isDeleted(rel));
        }
        Assert.assertTrue((String)("Expected deleted relationships not encountered " + expectedDeletedRelationships), (boolean)expectedDeletedRelationships.isEmpty());
        for (PropertyEntry entry : data.assignedNodeProperties()) {
            this.checkAssigned(expectedAssignedNodeProperties, entry);
            Assert.assertFalse((boolean)data.isDeleted((Node)entry.entity()));
        }
        Assert.assertTrue((String)("Expected assigned node properties not encountered " + expectedAssignedNodeProperties), (boolean)expectedAssignedNodeProperties.isEmpty());
        for (PropertyEntry entry : data.assignedRelationshipProperties()) {
            this.checkAssigned(expectedAssignedRelationshipProperties, entry);
            Assert.assertFalse((boolean)data.isDeleted((Relationship)entry.entity()));
        }
        Assert.assertTrue((String)("Expected assigned relationship properties not encountered " + expectedAssignedRelationshipProperties), (boolean)expectedAssignedRelationshipProperties.isEmpty());
        for (PropertyEntry entry : data.removedNodeProperties()) {
            this.checkRemoved(expectedRemovedNodeProperties, entry);
        }
        Assert.assertTrue((String)("Expected removed node properties not encountered " + expectedRemovedNodeProperties), (boolean)expectedRemovedNodeProperties.isEmpty());
        for (PropertyEntry entry : data.removedRelationshipProperties()) {
            this.checkRemoved(expectedRemovedRelationshipProperties, entry);
        }
        Assert.assertTrue((String)("Expected removed relationship properties not encountered " + expectedRemovedRelationshipProperties), (boolean)expectedRemovedRelationshipProperties.isEmpty());
        for (PropertyEntry entry : data.assignedLabels()) {
            this.check(expectedAssignedLabels, (LabelEntry)entry);
        }
        Assert.assertTrue((String)("Expected assigned labels not encountered " + expectedAssignedLabels), (boolean)expectedAssignedLabels.isEmpty());
        for (PropertyEntry entry : data.removedLabels()) {
            this.check(expectedRemovedLabels, (LabelEntry)entry);
        }
        Assert.assertTrue((String)("Expected removed labels not encountered " + expectedRemovedLabels), (boolean)expectedRemovedLabels.isEmpty());
    }

    private Map<Node, Set<String>> cloneLabelData(Map<Node, Set<String>> map) {
        HashMap<Node, Set<String>> clone = new HashMap<Node, Set<String>>();
        for (Map.Entry<Node, Set<String>> entry : map.entrySet()) {
            clone.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return clone;
    }

    private void check(Map<Node, Set<String>> expected, LabelEntry entry) {
        Node node = entry.node();
        String labelName = entry.label().name();
        boolean hasEntity = expected.containsKey(node);
        if (!hasEntity && this.ignoreAdditionalData) {
            return;
        }
        Assert.assertTrue((String)("Unexpected node " + node), (boolean)hasEntity);
        Set<String> labels = expected.get(node);
        boolean hasLabel = labels.remove(labelName);
        if (!hasLabel && this.ignoreAdditionalData) {
            return;
        }
        Assert.assertTrue((String)("Unexpected label " + labelName + " for " + node), (boolean)hasLabel);
        if (labels.isEmpty()) {
            expected.remove(node);
        }
    }

    private <KEY extends PropertyContainer> Map<KEY, Map<String, PropertyEntryImpl<KEY>>> clone(Map<KEY, Map<String, PropertyEntryImpl<KEY>>> map) {
        HashMap<PropertyContainer, HashMap<String, PropertyEntryImpl<KEY>>> result = new HashMap<PropertyContainer, HashMap<String, PropertyEntryImpl<KEY>>>();
        for (PropertyContainer key : map.keySet()) {
            result.put(key, new HashMap<String, PropertyEntryImpl<KEY>>(map.get(key)));
        }
        return result;
    }

    <T extends PropertyContainer> void checkAssigned(Map<T, Map<String, PropertyEntryImpl<T>>> map, PropertyEntry<T> entry) {
        PropertyEntryImpl<T> expected = this.fetchExpectedPropertyEntry(map, entry);
        if (expected != null) {
            expected.compareToAssigned(entry);
        }
    }

    <T extends PropertyContainer> void checkRemoved(Map<T, Map<String, PropertyEntryImpl<T>>> map, PropertyEntry<T> entry) {
        PropertyEntryImpl<T> expected = this.fetchExpectedPropertyEntry(map, entry);
        if (expected != null) {
            expected.compareToRemoved(entry);
        }
    }

    <T extends PropertyContainer> PropertyEntryImpl<T> fetchExpectedPropertyEntry(Map<T, Map<String, PropertyEntryImpl<T>>> map, PropertyEntry<T> entry) {
        PropertyContainer entity = entry.entity();
        boolean hasEntity = map.containsKey(entity);
        if (this.ignoreAdditionalData && !hasEntity) {
            return null;
        }
        Assert.assertTrue((String)("Unexpected entity " + entry), (boolean)hasEntity);
        Map<String, PropertyEntryImpl<T>> innerMap = map.get(entity);
        PropertyEntryImpl<T> expectedEntry = innerMap.remove(entry.key());
        if (expectedEntry == null && this.ignoreAdditionalData) {
            return null;
        }
        Assert.assertNotNull((String)("Unexpected property entry " + entry), expectedEntry);
        if (innerMap.isEmpty()) {
            map.remove(entity);
        }
        return expectedEntry;
    }
}

