/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;

public abstract class PropertyContainerProxyTest {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    protected abstract long createPropertyContainer();

    protected abstract PropertyContainer lookupPropertyContainer(long var1);

    @Test
    public void shouldListAllProperties() {
        Map listedProperties;
        long containerId;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("boolean", true);
        properties.put("short_string", "abc");
        properties.put("string", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        properties.put("long", Long.MAX_VALUE);
        properties.put("short_array", new long[]{1L, 2L, 3L, 4L});
        properties.put("array", new long[]{0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFDL, 0x7FFFFFFFFFFFFFFCL, 0x7FFFFFFFFFFFFFFBL, 0x7FFFFFFFFFFFFFFAL, 0x7FFFFFFFFFFFFFF9L, 0x7FFFFFFFFFFFFFF8L, 0x7FFFFFFFFFFFFFF7L, 0x7FFFFFFFFFFFFFF6L, 0x7FFFFFFFFFFFFFF5L, 0x7FFFFFFFFFFFFFF4L});
        try (Transaction tx = this.db.beginTx();){
            containerId = this.createPropertyContainer();
            PropertyContainer container = this.lookupPropertyContainer(containerId);
            for (Map.Entry entry : properties.entrySet()) {
                container.setProperty((String)entry.getKey(), entry.getValue());
            }
            tx.success();
        }
        try (Transaction tx = this.db.beginTx();){
            listedProperties = this.lookupPropertyContainer(containerId).getAllProperties();
            tx.success();
        }
        Assert.assertEquals((long)properties.size(), (long)listedProperties.size());
        for (String key : properties.keySet()) {
            org.neo4j.test.Assert.assertObjectOrArrayEquals(properties.get(key), listedProperties.get(key));
        }
    }
}

