/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.NamedThreadFactory;
import org.neo4j.kernel.impl.core.PropertyContainerProxyTest;

public class NodeProxyTest
extends PropertyContainerProxyTest {
    private final String PROPERTY_KEY = "PROPERTY_KEY";

    @Override
    protected long createPropertyContainer() {
        return this.db.createNode().getId();
    }

    @Override
    protected PropertyContainer lookupPropertyContainer(long id) {
        return this.db.getNodeById(id);
    }

    @Test
    public void shouldThrowHumaneExceptionsWhenPropertyDoesNotExistOnNode() throws Exception {
        this.createNodeWith("PROPERTY_KEY");
        try (Transaction ignored = this.db.beginTx();){
            Node node = this.db.createNode();
            node.getProperty("PROPERTY_KEY");
            Assert.fail((String)"Expected exception to have been thrown");
        }
        catch (NotFoundException exception) {
            Assert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"PROPERTY_KEY"));
        }
    }

    @Test
    public void shouldThrowHumaneExceptionsWhenPropertyDoesNotExist() throws Exception {
        try (Transaction ignored = this.db.beginTx();){
            Node node = this.db.createNode();
            node.getProperty("PROPERTY_KEY");
        }
        catch (NotFoundException exception) {
            Assert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"PROPERTY_KEY"));
        }
    }

    @Test(expected=NotFoundException.class)
    public void deletionOfSameNodeTwiceInOneTransactionShouldNotRollbackIt() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            tx.success();
        }
        Exception exceptionThrownBySecondDelete = null;
        try (Transaction tx = this.db.beginTx();){
            node.delete();
            try {
                node.delete();
            }
            catch (Exception e) {
                exceptionThrownBySecondDelete = e;
            }
            tx.success();
        }
        Assert.assertThat((Object)exceptionThrownBySecondDelete, (Matcher)Matchers.instanceOf(NotFoundException.class));
        tx = this.db.beginTx();
        var4_6 = null;
        try {
            this.db.getNodeById(node.getId());
            tx.success();
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var4_6.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test(expected=NotFoundException.class)
    public void deletionOfAlreadyDeletedNodeShouldThrow() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            tx.success();
        }
        tx = this.db.beginTx();
        var3_2 = null;
        try {
            node.delete();
            tx.success();
        }
        catch (Throwable x2) {
            var3_2 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var3_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var3_2 = null;
        try {
            node.delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var3_2.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test(timeout=10000L)
    public void getAllPropertiesShouldWorkFineWithConcurrentPropertyModifications() throws Exception {
        long nodeId;
        ExecutorService executor = this.cleanup.add(Executors.newFixedThreadPool(2, (ThreadFactory)NamedThreadFactory.named((String)"Test-executor-thread")));
        int propertiesCount = 1000;
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            nodeId = node.getId();
            for (int i = 0; i < 1000; ++i) {
                node.setProperty("property-" + i, (Object)i);
            }
            tx.success();
        }
        final AtomicBoolean start = new AtomicBoolean();
        final AtomicBoolean writerDone = new AtomicBoolean();
        Runnable writer = new Runnable(){

            @Override
            public void run() {
                try (Transaction tx = NodeProxyTest.this.db.beginTx();){
                    Node node = NodeProxyTest.this.db.getNodeById(nodeId);
                    while (!start.get()) {
                    }
                    for (int i = 0; i < 1000; ++i) {
                        node.setProperty("property-" + i, (Object)UUID.randomUUID().toString());
                    }
                    tx.success();
                }
                writerDone.set(true);
            }
        };
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                try (Transaction tx = NodeProxyTest.this.db.beginTx();){
                    Node node = NodeProxyTest.this.db.getNodeById(nodeId);
                    while (!start.get()) {
                    }
                    while (!writerDone.get()) {
                        int size = node.getAllProperties().size();
                        Assert.assertThat((Object)size, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
                    }
                    tx.success();
                }
            }
        };
        Future<?> readerFuture = executor.submit(reader);
        Future<?> writerFuture = executor.submit(writer);
        start.set(true);
        writerFuture.get();
        readerFuture.get();
        try (Transaction tx = this.db.beginTx();){
            Assert.assertEquals((long)1000L, (long)this.db.getNodeById(nodeId).getAllProperties().size());
            tx.success();
        }
    }

    private void createNodeWith(String key) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            node.setProperty(key, (Object)1);
            tx.success();
        }
    }
}

