/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.test.EmbeddedDatabaseRule;

public class BigStoreIT
implements RelationshipType {
    private static final RelationshipType OTHER_TYPE = DynamicRelationshipType.withName((String)"OTHER");
    private static final String PATH = "target/var/big";
    private GraphDatabaseService db;
    @Rule
    public TestName testName = new TestName(){

        public String getMethodName() {
            return BigStoreIT.this.getClass().getSimpleName() + "#" + super.getMethodName();
        }
    };
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule(BigStoreIT.class);
    private static final Label REFERENCE = DynamicLabel.label((String)"Reference");

    @Before
    public void doBefore() {
        AbstractNeo4jTestCase.deleteFileOrDirectory(new File(PATH));
        this.db = this.dbRule.getGraphDatabaseService();
    }

    public String name() {
        return "BIG_TYPE";
    }

    @Test
    public void create4BPlusStuff() throws Exception {
        this.testHighIds((long)Math.pow(2.0, 32.0), 2, 400);
    }

    @Test
    public void create8BPlusStuff() throws Exception {
        this.testHighIds((long)Math.pow(2.0, 33.0), 1, 1000);
    }

    @Test
    public void createAndVerify32BitGraph() throws Exception {
        this.createAndVerifyGraphStartingWithId((long)Math.pow(2.0, 32.0), 400);
    }

    @Test
    public void createAndVerify33BitGraph() throws Exception {
        this.createAndVerifyGraphStartingWithId((long)Math.pow(2.0, 33.0), 1000);
    }

    @Ignore(value="Blows up with a FileTooLarge error")
    @Test
    public void createAndVerify34BitGraph() throws Exception {
        this.createAndVerifyGraphStartingWithId((long)Math.pow(2.0, 34.0), 1600);
    }

    private void createAndVerifyGraphStartingWithId(long startId, int requiredHeapMb) throws Exception {
        Assume.assumeTrue((boolean)BigStoreIT.machineIsOkToRunThisTest(requiredHeapMb));
        Node refNode = this.createReferenceNode(this.db);
        this.setHighIds(startId - 1000L);
        byte[] bytes = new byte[45];
        bytes[2] = 5;
        bytes[10] = 42;
        Map properties = MapUtil.map((Object[])new Object[]{"number", 11, "short string", "test", "long string", "This is a long value, long enough", "array", bytes});
        Transaction tx = this.db.beginTx();
        int count = 10000;
        for (int i = 0; i < count; ++i) {
            Node node = this.db.createNode();
            this.setProperties((PropertyContainer)node, properties);
            Relationship rel1 = refNode.createRelationshipTo(node, (RelationshipType)this);
            this.setProperties((PropertyContainer)rel1, properties);
            Node highNode = this.db.createNode();
            Relationship rel2 = node.createRelationshipTo(highNode, OTHER_TYPE);
            this.setProperties((PropertyContainer)rel2, properties);
            this.setProperties((PropertyContainer)highNode, properties);
            if (i % 100 != 0 || i <= 0) continue;
            tx.success();
            tx.close();
            tx = this.db.beginTx();
        }
        tx.success();
        tx.close();
        this.db = this.dbRule.restartDatabase();
        int verified = 0;
        try (Transaction transaction = this.db.beginTx();){
            refNode = this.db.getNodeById(refNode.getId());
            for (Relationship rel : refNode.getRelationships(Direction.OUTGOING)) {
                Node node = rel.getEndNode();
                BigStoreIT.assertProperties(properties, (PropertyContainer)node);
                BigStoreIT.assertProperties(properties, (PropertyContainer)rel);
                Node highNode = node.getSingleRelationship(OTHER_TYPE, Direction.OUTGOING).getEndNode();
                BigStoreIT.assertProperties(properties, (PropertyContainer)highNode);
                ++verified;
            }
            transaction.success();
        }
        Assert.assertEquals((long)count, (long)verified);
    }

    private Node createReferenceNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(new Label[]{REFERENCE});
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    public static boolean machineIsOkToRunThisTest(int requiredHeapMb) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return false;
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            return false;
        }
        long heapMb = Runtime.getRuntime().maxMemory() / 1000000L;
        return heapMb >= (long)requiredHeapMb;
    }

    public static void assertProperties(Map<String, Object> properties, PropertyContainer entity) {
        int count = 0;
        for (String key : entity.getPropertyKeys()) {
            Object expectedValue = properties.get(key);
            Object entityValue = entity.getProperty(key);
            if (expectedValue.getClass().isArray()) {
                Assert.assertTrue((boolean)Arrays.equals((byte[])expectedValue, (byte[])entityValue));
            } else {
                Assert.assertEquals((Object)expectedValue, (Object)entityValue);
            }
            ++count;
        }
        Assert.assertEquals((long)properties.size(), (long)count);
    }

    private void setProperties(PropertyContainer entity, Map<String, Object> properties) {
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            entity.setProperty(property.getKey(), property.getValue());
        }
    }

    private void testHighIds(long highMark, int minus, int requiredHeapMb) throws IOException {
        if (!BigStoreIT.machineIsOkToRunThisTest(requiredHeapMb)) {
            return;
        }
        long idBelow = highMark - (long)minus;
        this.setHighIds(idBelow);
        String propertyKey = "name";
        int intPropertyValue = 123;
        String stringPropertyValue = "Long string, longer than would fit in shortstring";
        long[] arrayPropertyValue = new long[]{1021L, 321L, 343212L};
        Transaction tx = this.db.beginTx();
        Node nodeBelowTheLine = this.db.createNode();
        nodeBelowTheLine.setProperty(propertyKey, (Object)intPropertyValue);
        Assert.assertEquals((long)idBelow, (long)nodeBelowTheLine.getId());
        Node nodeAboveTheLine = this.db.createNode();
        nodeAboveTheLine.setProperty(propertyKey, (Object)stringPropertyValue);
        Relationship relBelowTheLine = nodeBelowTheLine.createRelationshipTo(nodeAboveTheLine, (RelationshipType)this);
        relBelowTheLine.setProperty(propertyKey, (Object)arrayPropertyValue);
        Assert.assertEquals((long)idBelow, (long)relBelowTheLine.getId());
        Relationship relAboveTheLine = nodeAboveTheLine.createRelationshipTo(nodeBelowTheLine, (RelationshipType)this);
        Assert.assertEquals((long)highMark, (long)relAboveTheLine.getId());
        Assert.assertEquals((long)highMark, (long)nodeAboveTheLine.getId());
        Assert.assertEquals((Object)intPropertyValue, (Object)nodeBelowTheLine.getProperty(propertyKey));
        Assert.assertEquals((Object)stringPropertyValue, (Object)nodeAboveTheLine.getProperty(propertyKey));
        Assert.assertTrue((boolean)Arrays.equals(arrayPropertyValue, (long[])relBelowTheLine.getProperty(propertyKey)));
        tx.success();
        tx.close();
        for (int i = 0; i < 2; ++i) {
            try (Transaction transaction = this.db.beginTx();){
                Assert.assertEquals((Object)nodeAboveTheLine, (Object)this.db.getNodeById(highMark));
                Assert.assertEquals((long)idBelow, (long)nodeBelowTheLine.getId());
                Assert.assertEquals((long)highMark, (long)nodeAboveTheLine.getId());
                Assert.assertEquals((long)idBelow, (long)relBelowTheLine.getId());
                Assert.assertEquals((long)highMark, (long)relAboveTheLine.getId());
                Assert.assertEquals((Object)relBelowTheLine, (Object)this.db.getNodeById(idBelow).getSingleRelationship((RelationshipType)this, Direction.OUTGOING));
                Assert.assertEquals((Object)relAboveTheLine, (Object)this.db.getNodeById(idBelow).getSingleRelationship((RelationshipType)this, Direction.INCOMING));
                Assert.assertEquals((long)idBelow, (long)relBelowTheLine.getId());
                Assert.assertEquals((long)highMark, (long)relAboveTheLine.getId());
                Assert.assertEquals(BigStoreIT.asSet(Arrays.asList(relBelowTheLine, relAboveTheLine)), BigStoreIT.asSet(IteratorUtil.asCollection((Iterable)this.db.getNodeById(idBelow).getRelationships())));
                transaction.success();
            }
            if (i != 0) continue;
            this.db = this.dbRule.restartDatabase();
        }
    }

    private void setHighIds(long id) {
        this.setHighId(IdType.NODE, id);
        this.setHighId(IdType.RELATIONSHIP, id);
        this.setHighId(IdType.PROPERTY, id);
        this.setHighId(IdType.ARRAY_BLOCK, id);
        this.setHighId(IdType.STRING_BLOCK, id);
    }

    private static <T> Collection<T> asSet(Collection<T> collection) {
        return new HashSet<T>(collection);
    }

    private void setHighId(IdType type, long highId) {
        ((IdGeneratorFactory)((GraphDatabaseAPI)this.db).getDependencyResolver().resolveDependency(IdGeneratorFactory.class)).get(type).setHighId(highId);
    }
}

