/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.neo4j.kernel.impl.cache.MeasureDoNothing;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Log;

public class MeasureDoNothingManualVerification {
    public static void main(String ... args) throws InterruptedException, ExecutionException {
        FormattedLog log = FormattedLog.toOutputStream(System.out);
        new Thread((Runnable)new MeasureDoNothing("GC Monitor", (Log)log, 100L, 1L)).start();
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        for (Future objectFuture : executorService.invokeAll(Arrays.asList(new GCHeavyJob(), new GCHeavyJob(), new GCHeavyJob(), new GCHeavyJob()))) {
            objectFuture.get();
        }
    }

    private static class GCHeavyJob
    implements Callable<Object> {
        Map<String, Object> objects = new ConcurrentHashMap<String, Object>();
        Random rand = new Random();

        private GCHeavyJob() {
        }

        @Override
        public Object call() throws Exception {
            while (true) {
                this.objects.put("key" + this.rand.nextInt(1000), ByteBuffer.allocate(8192));
            }
        }
    }
}

