/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.cursor.NodeItem;
import org.neo4j.kernel.impl.api.store.DiskLayerTest;
import org.neo4j.test.TestGraphDatabaseFactory;

public class DiskLayerLabelTest
extends DiskLayerTest {
    @Test
    public void should_be_able_to_list_labels_for_node() throws Exception {
        int labelId2;
        int labelId1;
        long nodeId;
        try (Transaction tx = this.db.beginTx();){
            nodeId = this.db.createNode(new Label[]{this.label1, this.label2}).getId();
            String labelName1 = this.label1.name();
            String labelName2 = this.label2.name();
            labelId1 = this.disk.labelGetForName(labelName1);
            labelId2 = this.disk.labelGetOrCreateForName(labelName2);
            tx.success();
        }
        Cursor node = this.disk.acquireStatement().acquireSingleNodeCursor(nodeId);
        node.next();
        PrimitiveIntIterator readLabels = ((NodeItem)node.get()).getLabels();
        Assert.assertEquals(new HashSet<Integer>(Arrays.asList(labelId1, labelId2)), (Object)IteratorUtil.addToCollection((PrimitiveIntIterator)readLabels, new HashSet()));
    }

    @Test
    public void should_be_able_to_get_label_name_for_label() throws Exception {
        String labelName = this.label1.name();
        int labelId = this.disk.labelGetOrCreateForName(labelName);
        String readLabelName = this.disk.labelGetName(labelId);
        Assert.assertEquals((Object)labelName, (Object)readLabelName);
    }

    @Test
    public void labels_should_not_leak_out_as_properties() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().newGraphDatabase();
        Node node = DiskLayerLabelTest.createLabeledNode(db, MapUtil.map((Object[])new Object[]{"name", "Node"}), this.label1);
        Assert.assertThat(Neo4jMatchers.getPropertyKeys(db, (PropertyContainer)node), Neo4jMatchers.containsOnly("name"));
        db.shutdown();
    }

    @Test
    public void should_return_all_nodes_with_label() throws Exception {
        Node node1 = DiskLayerLabelTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", "First", "age", 1L}), this.label1);
        Node node2 = DiskLayerLabelTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"type", "Node", "count", 10}), this.label1, this.label2);
        int labelId1 = this.disk.labelGetForName(this.label1.name());
        int labelId2 = this.disk.labelGetForName(this.label2.name());
        PrimitiveLongIterator nodesForLabel1 = this.disk.nodesGetForLabel(this.state, labelId1);
        PrimitiveLongIterator nodesForLabel2 = this.disk.nodesGetForLabel(this.state, labelId2);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{node1.getId(), node2.getId()}), (Object)IteratorUtil.asSet((PrimitiveLongIterator)nodesForLabel1));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{node2.getId()}), (Object)IteratorUtil.asSet((PrimitiveLongIterator)nodesForLabel2));
    }
}

