/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.store.DiskLayerTest;

public class DiskLayerIndexTest
extends DiskLayerTest {
    @Test
    public void should_find_nodes_with_given_label_and_property_via_index() throws Exception {
        IndexDescriptor descriptor = new IndexDescriptor(0, 0);
        this.createIndexAndAwaitOnline(this.label1, "name");
        String name = "Mr. Taylor";
        Node mrTaylor = DiskLayerIndexTest.createLabeledNode((GraphDatabaseService)this.db, MapUtil.map((Object[])new Object[]{"name", name}), this.label1);
        try (Transaction ignored = this.db.beginTx();){
            Set foundNodes = IteratorUtil.asUniqueSet((PrimitiveLongIterator)this.disk.nodesGetFromIndexSeek(this.state, descriptor, (Object)name));
            Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{mrTaylor.getId()}), (Object)foundNodes);
        }
    }
}

