/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.cursor.NodeItem;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.LegacyPropertyTrackers;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.index.LegacyIndexStore;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;

public class StateHandlingStatementOperationsTest {
    StoreReadLayer inner = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);

    @Test
    public void shouldNeverDelegateWrites() throws Exception {
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        Mockito.when((Object)state.txState()).thenReturn((Object)new TxState());
        StoreStatement storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Mockito.when((Object)state.getStoreStatement()).thenReturn((Object)storeStatement);
        Mockito.when((Object)storeStatement.acquireSingleNodeCursor(Matchers.anyLong())).thenReturn(StubCursors.asNodeCursor(0L));
        StateHandlingStatementOperations ctx = this.newTxStateOps(this.inner);
        ctx.indexCreate(state, 0, 0);
        ctx.nodeAddLabel(state, 0L, 0);
        ctx.indexDrop(state, new IndexDescriptor(0, 0));
        ctx.nodeRemoveLabel(state, 0L, 0);
        ((StoreStatement)Mockito.verify((Object)storeStatement, (VerificationMode)Mockito.times((int)2))).acquireSingleNodeCursor(0L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{storeStatement});
    }

    @Test
    public void shouldNotAddConstraintAlreadyExistsInTheStore() throws Exception {
        UniquenessConstraint constraint = new UniquenessConstraint(10, 66);
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        Mockito.when((Object)txState.nodesWithLabelChanged(Matchers.anyInt())).thenReturn((Object)new DiffSets());
        Mockito.when((Object)txState.hasChanges()).thenReturn((Object)true);
        KernelStatement state = StatementOperationsTestHelper.mockedState(txState);
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(10, 66)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(Arrays.asList(constraint)));
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquePropertyConstraintCreate(state, 10, 66);
        ((TransactionState)Mockito.verify((Object)txState)).constraintIndexDoUnRemove((IndexDescriptor)Matchers.any(IndexDescriptor.class));
    }

    @Test
    public void shouldGetConstraintsByLabelAndProperty() throws Exception {
        UniquenessConstraint constraint = new UniquenessConstraint(10, 66);
        TxState txState = new TxState();
        KernelStatement state = StatementOperationsTestHelper.mockedState((TransactionState)txState);
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(10, 66)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(Collections.emptyList()));
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquePropertyConstraintCreate(state, 10, 66);
        Set result = IteratorUtil.asSet((Iterable)IteratorUtil.asIterable((Iterator)context.constraintsGetForLabelAndPropertyKey(state, 10, 66)));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new PropertyConstraint[]{constraint}), (Object)result);
    }

    @Test
    public void shouldGetConstraintsByLabel() throws Exception {
        UniquenessConstraint constraint2 = new UniquenessConstraint(11, 99);
        UniquenessConstraint constraint1 = new UniquenessConstraint(11, 66);
        TxState txState = new TxState();
        KernelStatement state = StatementOperationsTestHelper.mockedState((TransactionState)txState);
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(10, 66)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(Collections.emptyList()));
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(11, 99)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(Collections.emptyList()));
        Mockito.when((Object)this.inner.constraintsGetForLabel(10)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(Collections.emptyList()));
        Mockito.when((Object)this.inner.constraintsGetForLabel(11)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(IteratorUtil.asIterable((Object[])new PropertyConstraint[]{constraint1})));
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquePropertyConstraintCreate(state, 10, 66);
        context.uniquePropertyConstraintCreate(state, 11, 99);
        Set result = IteratorUtil.asSet((Iterable)IteratorUtil.asIterable((Iterator)context.constraintsGetForLabel(state, 11)));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new PropertyConstraint[]{constraint1, constraint2}), (Object)result);
    }

    @Test
    public void shouldGetAllConstraints() throws Exception {
        UniquenessConstraint constraint1 = new UniquenessConstraint(10, 66);
        UniquenessConstraint constraint2 = new UniquenessConstraint(11, 99);
        TxState txState = new TxState();
        KernelStatement state = StatementOperationsTestHelper.mockedState((TransactionState)txState);
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(10, 66)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(Collections.emptyList()));
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(11, 99)).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(Collections.emptyList()));
        Mockito.when((Object)this.inner.constraintsGetAll()).thenAnswer(StateHandlingStatementOperationsTest.asAnswer(IteratorUtil.asIterable((Object[])new PropertyConstraint[]{constraint2})));
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquePropertyConstraintCreate(state, 10, 66);
        Set result = IteratorUtil.asSet((Iterable)IteratorUtil.asIterable((Iterator)context.constraintsGetAll(state)));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new PropertyConstraint[]{constraint1, constraint2}), (Object)result);
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexScan() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        IndexDescriptor index = new IndexDescriptor(1, 2);
        Mockito.when((Object)txState.indexUpdatesForScanOrSeek(index, null)).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)storeReadLayer.nodesGetFromIndexScan(statement, index)).thenReturn((Object)IteratorUtil.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator(43L, 44L, 46L), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.nodesGetFromIndexScan(statement, index);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L}), (Object)IteratorUtil.asSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexSeek() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        IndexDescriptor index = new IndexDescriptor(1, 2);
        Mockito.when((Object)txState.indexUpdatesForScanOrSeek(index, (Object)"value")).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)storeReadLayer.nodesGetFromIndexSeek(statement, index, (Object)"value")).thenReturn((Object)IteratorUtil.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator(43L, 44L, 46L), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.nodesGetFromIndexSeek(statement, index, (Object)"value");
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L}), (Object)IteratorUtil.asSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexRangeSeekByPrefix() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        IndexDescriptor index = new IndexDescriptor(1, 2);
        Mockito.when((Object)txState.indexUpdatesForRangeSeekByPrefix(index, "prefix")).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)storeReadLayer.nodesGetFromIndexRangeSeekByPrefix(statement, index, "prefix")).thenReturn((Object)IteratorUtil.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator(43L, 44L, 46L), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.nodesGetFromIndexRangeSeekByPrefix(statement, index, "prefix");
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L}), (Object)IteratorUtil.asSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexBetweenRangeSeekByNumber() throws Exception {
        int propertyKey = 2;
        int inRange = 15;
        int lower = 10;
        int upper = 20;
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        IndexDescriptor index = new IndexDescriptor(1, 2);
        Mockito.when((Object)txState.indexUpdatesForRangeSeekByNumber(index, (Number)lower, true, (Number)upper, false)).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        Mockito.when((Object)txState.augmentSingleNodeCursor((Cursor)Matchers.any(Cursor.class), Matchers.anyLong())).thenAnswer((Answer)new Answer<Cursor<NodeItem>>(){

            public Cursor<NodeItem> answer(InvocationOnMock invocationOnMock) throws Throwable {
                long nodeId = (Long)invocationOnMock.getArguments()[1];
                return StubCursors.asNodeCursor(nodeId, StubCursors.asPropertyCursor(Property.intProperty((int)2, (int)15)), Cursors.empty());
            }
        });
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)storeReadLayer.nodesGetFromInclusiveNumericIndexRangeSeek(statement, index, (Number)lower, (Number)upper)).thenReturn((Object)IteratorUtil.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator(43L, 44L, 46L), null));
        StoreStatement storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Mockito.when((Object)statement.getStoreStatement()).thenReturn((Object)storeStatement);
        Mockito.when((Object)storeStatement.acquireSingleNodeCursor(Matchers.anyLong())).thenAnswer((Answer)new Answer<Cursor<NodeItem>>(){

            public Cursor<NodeItem> answer(InvocationOnMock invocationOnMock) throws Throwable {
                long nodeId = (Long)invocationOnMock.getArguments()[0];
                return StubCursors.asNodeCursor(nodeId, StubCursors.asPropertyCursor(Property.intProperty((int)2, (int)15)), Cursors.empty());
            }
        });
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.nodesGetFromIndexRangeSeekByNumber(statement, index, (Number)lower, true, (Number)upper, false);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L}), (Object)IteratorUtil.asSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexBetweenRangeSeekByString() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        IndexDescriptor index = new IndexDescriptor(1, 2);
        Mockito.when((Object)txState.indexUpdatesForRangeSeekByString(index, "Anne", true, "Bill", false)).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        Mockito.when((Object)storeReadLayer.nodesGetFromIndexRangeSeekByString(statement, index, "Anne", true, "Bill", false)).thenReturn((Object)IteratorUtil.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator(43L, 44L, 46L), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.nodesGetFromIndexRangeSeekByString(statement, index, "Anne", true, "Bill", false);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L}), (Object)IteratorUtil.asSet((PrimitiveLongIterator)results));
    }

    private static <T> Answer<Iterator<T>> asAnswer(final Iterable<T> values) {
        return new Answer<Iterator<T>>(){

            public Iterator<T> answer(InvocationOnMock invocation) throws Throwable {
                return values.iterator();
            }
        };
    }

    private StateHandlingStatementOperations newTxStateOps(StoreReadLayer delegate) {
        return new StateHandlingStatementOperations(delegate, (LegacyPropertyTrackers)Mockito.mock(LegacyPropertyTrackers.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (LegacyIndexStore)Mockito.mock(LegacyIndexStore.class));
    }
}

